/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mailmanager.model.AcceptAction;
import com.amazonaws.services.mailmanager.model.PolicyStatement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateTrafficPolicyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String defaultAction;
    private Integer maxMessageSizeBytes;
    private List<PolicyStatement> policyStatements;
    private String trafficPolicyId;
    private String trafficPolicyName;

    public void setDefaultAction(String defaultAction) {
        this.defaultAction = defaultAction;
    }

    public String getDefaultAction() {
        return this.defaultAction;
    }

    public UpdateTrafficPolicyRequest withDefaultAction(String defaultAction) {
        this.setDefaultAction(defaultAction);
        return this;
    }

    public UpdateTrafficPolicyRequest withDefaultAction(AcceptAction defaultAction) {
        this.defaultAction = defaultAction.toString();
        return this;
    }

    public void setMaxMessageSizeBytes(Integer maxMessageSizeBytes) {
        this.maxMessageSizeBytes = maxMessageSizeBytes;
    }

    public Integer getMaxMessageSizeBytes() {
        return this.maxMessageSizeBytes;
    }

    public UpdateTrafficPolicyRequest withMaxMessageSizeBytes(Integer maxMessageSizeBytes) {
        this.setMaxMessageSizeBytes(maxMessageSizeBytes);
        return this;
    }

    public List<PolicyStatement> getPolicyStatements() {
        return this.policyStatements;
    }

    public void setPolicyStatements(Collection<PolicyStatement> policyStatements) {
        if (policyStatements == null) {
            this.policyStatements = null;
            return;
        }
        this.policyStatements = new ArrayList<PolicyStatement>(policyStatements);
    }

    public UpdateTrafficPolicyRequest withPolicyStatements(PolicyStatement ... policyStatements) {
        if (this.policyStatements == null) {
            this.setPolicyStatements(new ArrayList<PolicyStatement>(policyStatements.length));
        }
        for (PolicyStatement ele : policyStatements) {
            this.policyStatements.add(ele);
        }
        return this;
    }

    public UpdateTrafficPolicyRequest withPolicyStatements(Collection<PolicyStatement> policyStatements) {
        this.setPolicyStatements(policyStatements);
        return this;
    }

    public void setTrafficPolicyId(String trafficPolicyId) {
        this.trafficPolicyId = trafficPolicyId;
    }

    public String getTrafficPolicyId() {
        return this.trafficPolicyId;
    }

    public UpdateTrafficPolicyRequest withTrafficPolicyId(String trafficPolicyId) {
        this.setTrafficPolicyId(trafficPolicyId);
        return this;
    }

    public void setTrafficPolicyName(String trafficPolicyName) {
        this.trafficPolicyName = trafficPolicyName;
    }

    public String getTrafficPolicyName() {
        return this.trafficPolicyName;
    }

    public UpdateTrafficPolicyRequest withTrafficPolicyName(String trafficPolicyName) {
        this.setTrafficPolicyName(trafficPolicyName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultAction() != null) {
            sb.append("DefaultAction: ").append(this.getDefaultAction()).append(",");
        }
        if (this.getMaxMessageSizeBytes() != null) {
            sb.append("MaxMessageSizeBytes: ").append(this.getMaxMessageSizeBytes()).append(",");
        }
        if (this.getPolicyStatements() != null) {
            sb.append("PolicyStatements: ").append(this.getPolicyStatements()).append(",");
        }
        if (this.getTrafficPolicyId() != null) {
            sb.append("TrafficPolicyId: ").append(this.getTrafficPolicyId()).append(",");
        }
        if (this.getTrafficPolicyName() != null) {
            sb.append("TrafficPolicyName: ").append(this.getTrafficPolicyName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyRequest)) {
            return false;
        }
        UpdateTrafficPolicyRequest other = (UpdateTrafficPolicyRequest)obj;
        if (other.getDefaultAction() == null ^ this.getDefaultAction() == null) {
            return false;
        }
        if (other.getDefaultAction() != null && !other.getDefaultAction().equals(this.getDefaultAction())) {
            return false;
        }
        if (other.getMaxMessageSizeBytes() == null ^ this.getMaxMessageSizeBytes() == null) {
            return false;
        }
        if (other.getMaxMessageSizeBytes() != null && !other.getMaxMessageSizeBytes().equals(this.getMaxMessageSizeBytes())) {
            return false;
        }
        if (other.getPolicyStatements() == null ^ this.getPolicyStatements() == null) {
            return false;
        }
        if (other.getPolicyStatements() != null && !other.getPolicyStatements().equals(this.getPolicyStatements())) {
            return false;
        }
        if (other.getTrafficPolicyId() == null ^ this.getTrafficPolicyId() == null) {
            return false;
        }
        if (other.getTrafficPolicyId() != null && !other.getTrafficPolicyId().equals(this.getTrafficPolicyId())) {
            return false;
        }
        if (other.getTrafficPolicyName() == null ^ this.getTrafficPolicyName() == null) {
            return false;
        }
        return other.getTrafficPolicyName() == null || other.getTrafficPolicyName().equals(this.getTrafficPolicyName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultAction() == null ? 0 : this.getDefaultAction().hashCode());
        hashCode = 31 * hashCode + (this.getMaxMessageSizeBytes() == null ? 0 : this.getMaxMessageSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyStatements() == null ? 0 : this.getPolicyStatements().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficPolicyId() == null ? 0 : this.getTrafficPolicyId().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficPolicyName() == null ? 0 : this.getTrafficPolicyName().hashCode());
        return hashCode;
    }

    public UpdateTrafficPolicyRequest clone() {
        return (UpdateTrafficPolicyRequest)super.clone();
    }
}

