/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mailmanager.model.RelayAuthentication;
import com.amazonaws.services.mailmanager.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateRelayRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private RelayAuthentication authentication;
    private String clientToken;
    private String relayName;
    private String serverName;
    private Integer serverPort;
    private List<Tag> tags;

    public void setAuthentication(RelayAuthentication authentication) {
        this.authentication = authentication;
    }

    public RelayAuthentication getAuthentication() {
        return this.authentication;
    }

    public CreateRelayRequest withAuthentication(RelayAuthentication authentication) {
        this.setAuthentication(authentication);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateRelayRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setRelayName(String relayName) {
        this.relayName = relayName;
    }

    public String getRelayName() {
        return this.relayName;
    }

    public CreateRelayRequest withRelayName(String relayName) {
        this.setRelayName(relayName);
        return this;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public CreateRelayRequest withServerName(String serverName) {
        this.setServerName(serverName);
        return this;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public CreateRelayRequest withServerPort(Integer serverPort) {
        this.setServerPort(serverPort);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateRelayRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateRelayRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthentication() != null) {
            sb.append("Authentication: ").append(this.getAuthentication()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getRelayName() != null) {
            sb.append("RelayName: ").append(this.getRelayName()).append(",");
        }
        if (this.getServerName() != null) {
            sb.append("ServerName: ").append(this.getServerName()).append(",");
        }
        if (this.getServerPort() != null) {
            sb.append("ServerPort: ").append(this.getServerPort()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelayRequest)) {
            return false;
        }
        CreateRelayRequest other = (CreateRelayRequest)obj;
        if (other.getAuthentication() == null ^ this.getAuthentication() == null) {
            return false;
        }
        if (other.getAuthentication() != null && !other.getAuthentication().equals(this.getAuthentication())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getRelayName() == null ^ this.getRelayName() == null) {
            return false;
        }
        if (other.getRelayName() != null && !other.getRelayName().equals(this.getRelayName())) {
            return false;
        }
        if (other.getServerName() == null ^ this.getServerName() == null) {
            return false;
        }
        if (other.getServerName() != null && !other.getServerName().equals(this.getServerName())) {
            return false;
        }
        if (other.getServerPort() == null ^ this.getServerPort() == null) {
            return false;
        }
        if (other.getServerPort() != null && !other.getServerPort().equals(this.getServerPort())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthentication() == null ? 0 : this.getAuthentication().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getRelayName() == null ? 0 : this.getRelayName().hashCode());
        hashCode = 31 * hashCode + (this.getServerName() == null ? 0 : this.getServerName().hashCode());
        hashCode = 31 * hashCode + (this.getServerPort() == null ? 0 : this.getServerPort().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateRelayRequest clone() {
        return (CreateRelayRequest)super.clone();
    }
}

