/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.machinelearning.model.RDSMetadata;
import com.amazonaws.services.machinelearning.model.transform.RDSDatabaseJsonMarshaller;

public class RDSMetadataJsonMarshaller {
    private static RDSMetadataJsonMarshaller instance;

    public void marshall(RDSMetadata rDSMetadata, StructuredJsonGenerator jsonGenerator) {
        if (rDSMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (rDSMetadata.getDatabase() != null) {
                jsonGenerator.writeFieldName("Database");
                RDSDatabaseJsonMarshaller.getInstance().marshall(rDSMetadata.getDatabase(), jsonGenerator);
            }
            if (rDSMetadata.getDatabaseUserName() != null) {
                jsonGenerator.writeFieldName("DatabaseUserName").writeValue(rDSMetadata.getDatabaseUserName());
            }
            if (rDSMetadata.getSelectSqlQuery() != null) {
                jsonGenerator.writeFieldName("SelectSqlQuery").writeValue(rDSMetadata.getSelectSqlQuery());
            }
            if (rDSMetadata.getResourceRole() != null) {
                jsonGenerator.writeFieldName("ResourceRole").writeValue(rDSMetadata.getResourceRole());
            }
            if (rDSMetadata.getServiceRole() != null) {
                jsonGenerator.writeFieldName("ServiceRole").writeValue(rDSMetadata.getServiceRole());
            }
            if (rDSMetadata.getDataPipelineId() != null) {
                jsonGenerator.writeFieldName("DataPipelineId").writeValue(rDSMetadata.getDataPipelineId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RDSMetadataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RDSMetadataJsonMarshaller();
        }
        return instance;
    }
}

