/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.machinelearning.model.Evaluation;
import com.amazonaws.services.machinelearning.model.transform.PerformanceMetricsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class EvaluationJsonMarshaller {
    private static EvaluationJsonMarshaller instance;

    public void marshall(Evaluation evaluation, JSONWriter jsonWriter) {
        if (evaluation == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (evaluation.getEvaluationId() != null) {
                jsonWriter.key("EvaluationId").value((Object)evaluation.getEvaluationId());
            }
            if (evaluation.getMLModelId() != null) {
                jsonWriter.key("MLModelId").value((Object)evaluation.getMLModelId());
            }
            if (evaluation.getEvaluationDataSourceId() != null) {
                jsonWriter.key("EvaluationDataSourceId").value((Object)evaluation.getEvaluationDataSourceId());
            }
            if (evaluation.getInputDataLocationS3() != null) {
                jsonWriter.key("InputDataLocationS3").value((Object)evaluation.getInputDataLocationS3());
            }
            if (evaluation.getCreatedByIamUser() != null) {
                jsonWriter.key("CreatedByIamUser").value((Object)evaluation.getCreatedByIamUser());
            }
            if (evaluation.getCreatedAt() != null) {
                jsonWriter.key("CreatedAt").value(evaluation.getCreatedAt());
            }
            if (evaluation.getLastUpdatedAt() != null) {
                jsonWriter.key("LastUpdatedAt").value(evaluation.getLastUpdatedAt());
            }
            if (evaluation.getName() != null) {
                jsonWriter.key("Name").value((Object)evaluation.getName());
            }
            if (evaluation.getStatus() != null) {
                jsonWriter.key("Status").value((Object)evaluation.getStatus());
            }
            if (evaluation.getPerformanceMetrics() != null) {
                jsonWriter.key("PerformanceMetrics");
                PerformanceMetricsJsonMarshaller.getInstance().marshall(evaluation.getPerformanceMetrics(), jsonWriter);
            }
            if (evaluation.getMessage() != null) {
                jsonWriter.key("Message").value((Object)evaluation.getMessage());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EvaluationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EvaluationJsonMarshaller();
        }
        return instance;
    }
}

