/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Request;
import com.amazonaws.services.machinelearning.model.S3DataSpec;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateDataSourceFromS3RequestMarshaller
implements Marshaller<Request<CreateDataSourceFromS3Request>, CreateDataSourceFromS3Request> {
    public Request<CreateDataSourceFromS3Request> marshall(CreateDataSourceFromS3Request createDataSourceFromS3Request) {
        if (createDataSourceFromS3Request == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDataSourceFromS3Request, "AmazonMachineLearning");
        String target = "AmazonML_20141212.CreateDataSourceFromS3";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            S3DataSpec dataSpec;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createDataSourceFromS3Request.getDataSourceId() != null) {
                jsonWriter.key("DataSourceId").value((Object)createDataSourceFromS3Request.getDataSourceId());
            }
            if (createDataSourceFromS3Request.getDataSourceName() != null) {
                jsonWriter.key("DataSourceName").value((Object)createDataSourceFromS3Request.getDataSourceName());
            }
            if ((dataSpec = createDataSourceFromS3Request.getDataSpec()) != null) {
                jsonWriter.key("DataSpec");
                jsonWriter.object();
                if (dataSpec.getDataLocationS3() != null) {
                    jsonWriter.key("DataLocationS3").value((Object)dataSpec.getDataLocationS3());
                }
                if (dataSpec.getDataRearrangement() != null) {
                    jsonWriter.key("DataRearrangement").value((Object)dataSpec.getDataRearrangement());
                }
                if (dataSpec.getDataSchema() != null) {
                    jsonWriter.key("DataSchema").value((Object)dataSpec.getDataSchema());
                }
                if (dataSpec.getDataSchemaLocationS3() != null) {
                    jsonWriter.key("DataSchemaLocationS3").value((Object)dataSpec.getDataSchemaLocationS3());
                }
                jsonWriter.endObject();
            }
            if (createDataSourceFromS3Request.isComputeStatistics() != null) {
                jsonWriter.key("ComputeStatistics").value((Object)createDataSourceFromS3Request.isComputeStatistics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

