/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.machinelearning.model.RDSDatabase;
import com.amazonaws.services.machinelearning.model.RDSDatabaseCredentials;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RDSDataSpec
implements Serializable,
Cloneable {
    private RDSDatabase databaseInformation;
    private String selectSqlQuery;
    private RDSDatabaseCredentials databaseCredentials;
    private String s3StagingLocation;
    private String dataRearrangement;
    private String dataSchema;
    private String dataSchemaUri;
    private String resourceRole;
    private String serviceRole;
    private String subnetId;
    private ListWithAutoConstructFlag<String> securityGroupIds;

    public RDSDatabase getDatabaseInformation() {
        return this.databaseInformation;
    }

    public void setDatabaseInformation(RDSDatabase databaseInformation) {
        this.databaseInformation = databaseInformation;
    }

    public RDSDataSpec withDatabaseInformation(RDSDatabase databaseInformation) {
        this.databaseInformation = databaseInformation;
        return this;
    }

    public String getSelectSqlQuery() {
        return this.selectSqlQuery;
    }

    public void setSelectSqlQuery(String selectSqlQuery) {
        this.selectSqlQuery = selectSqlQuery;
    }

    public RDSDataSpec withSelectSqlQuery(String selectSqlQuery) {
        this.selectSqlQuery = selectSqlQuery;
        return this;
    }

    public RDSDatabaseCredentials getDatabaseCredentials() {
        return this.databaseCredentials;
    }

    public void setDatabaseCredentials(RDSDatabaseCredentials databaseCredentials) {
        this.databaseCredentials = databaseCredentials;
    }

    public RDSDataSpec withDatabaseCredentials(RDSDatabaseCredentials databaseCredentials) {
        this.databaseCredentials = databaseCredentials;
        return this;
    }

    public String getS3StagingLocation() {
        return this.s3StagingLocation;
    }

    public void setS3StagingLocation(String s3StagingLocation) {
        this.s3StagingLocation = s3StagingLocation;
    }

    public RDSDataSpec withS3StagingLocation(String s3StagingLocation) {
        this.s3StagingLocation = s3StagingLocation;
        return this;
    }

    public String getDataRearrangement() {
        return this.dataRearrangement;
    }

    public void setDataRearrangement(String dataRearrangement) {
        this.dataRearrangement = dataRearrangement;
    }

    public RDSDataSpec withDataRearrangement(String dataRearrangement) {
        this.dataRearrangement = dataRearrangement;
        return this;
    }

    public String getDataSchema() {
        return this.dataSchema;
    }

    public void setDataSchema(String dataSchema) {
        this.dataSchema = dataSchema;
    }

    public RDSDataSpec withDataSchema(String dataSchema) {
        this.dataSchema = dataSchema;
        return this;
    }

    public String getDataSchemaUri() {
        return this.dataSchemaUri;
    }

    public void setDataSchemaUri(String dataSchemaUri) {
        this.dataSchemaUri = dataSchemaUri;
    }

    public RDSDataSpec withDataSchemaUri(String dataSchemaUri) {
        this.dataSchemaUri = dataSchemaUri;
        return this;
    }

    public String getResourceRole() {
        return this.resourceRole;
    }

    public void setResourceRole(String resourceRole) {
        this.resourceRole = resourceRole;
    }

    public RDSDataSpec withResourceRole(String resourceRole) {
        this.resourceRole = resourceRole;
        return this;
    }

    public String getServiceRole() {
        return this.serviceRole;
    }

    public void setServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
    }

    public RDSDataSpec withServiceRole(String serviceRole) {
        this.serviceRole = serviceRole;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public RDSDataSpec withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public List<String> getSecurityGroupIds() {
        if (this.securityGroupIds == null) {
            this.securityGroupIds = new ListWithAutoConstructFlag();
            this.securityGroupIds.setAutoConstruct(true);
        }
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        ListWithAutoConstructFlag securityGroupIdsCopy = new ListWithAutoConstructFlag(securityGroupIds.size());
        securityGroupIdsCopy.addAll(securityGroupIds);
        this.securityGroupIds = securityGroupIdsCopy;
    }

    public RDSDataSpec withSecurityGroupIds(String ... securityGroupIds) {
        if (this.getSecurityGroupIds() == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String value : securityGroupIds) {
            this.getSecurityGroupIds().add(value);
        }
        return this;
    }

    public RDSDataSpec withSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
        } else {
            ListWithAutoConstructFlag securityGroupIdsCopy = new ListWithAutoConstructFlag(securityGroupIds.size());
            securityGroupIdsCopy.addAll(securityGroupIds);
            this.securityGroupIds = securityGroupIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatabaseInformation() != null) {
            sb.append("DatabaseInformation: " + this.getDatabaseInformation() + ",");
        }
        if (this.getSelectSqlQuery() != null) {
            sb.append("SelectSqlQuery: " + this.getSelectSqlQuery() + ",");
        }
        if (this.getDatabaseCredentials() != null) {
            sb.append("DatabaseCredentials: " + this.getDatabaseCredentials() + ",");
        }
        if (this.getS3StagingLocation() != null) {
            sb.append("S3StagingLocation: " + this.getS3StagingLocation() + ",");
        }
        if (this.getDataRearrangement() != null) {
            sb.append("DataRearrangement: " + this.getDataRearrangement() + ",");
        }
        if (this.getDataSchema() != null) {
            sb.append("DataSchema: " + this.getDataSchema() + ",");
        }
        if (this.getDataSchemaUri() != null) {
            sb.append("DataSchemaUri: " + this.getDataSchemaUri() + ",");
        }
        if (this.getResourceRole() != null) {
            sb.append("ResourceRole: " + this.getResourceRole() + ",");
        }
        if (this.getServiceRole() != null) {
            sb.append("ServiceRole: " + this.getServiceRole() + ",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: " + this.getSecurityGroupIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatabaseInformation() == null ? 0 : this.getDatabaseInformation().hashCode());
        hashCode = 31 * hashCode + (this.getSelectSqlQuery() == null ? 0 : this.getSelectSqlQuery().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseCredentials() == null ? 0 : this.getDatabaseCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getS3StagingLocation() == null ? 0 : this.getS3StagingLocation().hashCode());
        hashCode = 31 * hashCode + (this.getDataRearrangement() == null ? 0 : this.getDataRearrangement().hashCode());
        hashCode = 31 * hashCode + (this.getDataSchema() == null ? 0 : this.getDataSchema().hashCode());
        hashCode = 31 * hashCode + (this.getDataSchemaUri() == null ? 0 : this.getDataSchemaUri().hashCode());
        hashCode = 31 * hashCode + (this.getResourceRole() == null ? 0 : this.getResourceRole().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRole() == null ? 0 : this.getServiceRole().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSDataSpec)) {
            return false;
        }
        RDSDataSpec other = (RDSDataSpec)obj;
        if (other.getDatabaseInformation() == null ^ this.getDatabaseInformation() == null) {
            return false;
        }
        if (other.getDatabaseInformation() != null && !other.getDatabaseInformation().equals(this.getDatabaseInformation())) {
            return false;
        }
        if (other.getSelectSqlQuery() == null ^ this.getSelectSqlQuery() == null) {
            return false;
        }
        if (other.getSelectSqlQuery() != null && !other.getSelectSqlQuery().equals(this.getSelectSqlQuery())) {
            return false;
        }
        if (other.getDatabaseCredentials() == null ^ this.getDatabaseCredentials() == null) {
            return false;
        }
        if (other.getDatabaseCredentials() != null && !other.getDatabaseCredentials().equals(this.getDatabaseCredentials())) {
            return false;
        }
        if (other.getS3StagingLocation() == null ^ this.getS3StagingLocation() == null) {
            return false;
        }
        if (other.getS3StagingLocation() != null && !other.getS3StagingLocation().equals(this.getS3StagingLocation())) {
            return false;
        }
        if (other.getDataRearrangement() == null ^ this.getDataRearrangement() == null) {
            return false;
        }
        if (other.getDataRearrangement() != null && !other.getDataRearrangement().equals(this.getDataRearrangement())) {
            return false;
        }
        if (other.getDataSchema() == null ^ this.getDataSchema() == null) {
            return false;
        }
        if (other.getDataSchema() != null && !other.getDataSchema().equals(this.getDataSchema())) {
            return false;
        }
        if (other.getDataSchemaUri() == null ^ this.getDataSchemaUri() == null) {
            return false;
        }
        if (other.getDataSchemaUri() != null && !other.getDataSchemaUri().equals(this.getDataSchemaUri())) {
            return false;
        }
        if (other.getResourceRole() == null ^ this.getResourceRole() == null) {
            return false;
        }
        if (other.getResourceRole() != null && !other.getResourceRole().equals(this.getResourceRole())) {
            return false;
        }
        if (other.getServiceRole() == null ^ this.getServiceRole() == null) {
            return false;
        }
        if (other.getServiceRole() != null && !other.getServiceRole().equals(this.getServiceRole())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        return other.getSecurityGroupIds() == null || other.getSecurityGroupIds().equals(this.getSecurityGroupIds());
    }

    public RDSDataSpec clone() {
        try {
            return (RDSDataSpec)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

