/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.machinelearning.model.RDSMetadata;
import com.amazonaws.services.machinelearning.model.transform.RDSDatabaseJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class RDSMetadataJsonMarshaller {
    private static RDSMetadataJsonMarshaller instance;

    public void marshall(RDSMetadata rDSMetadata, JSONWriter jsonWriter) {
        if (rDSMetadata == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (rDSMetadata.getDatabase() != null) {
                jsonWriter.key("Database");
                RDSDatabaseJsonMarshaller.getInstance().marshall(rDSMetadata.getDatabase(), jsonWriter);
            }
            if (rDSMetadata.getDatabaseUserName() != null) {
                jsonWriter.key("DatabaseUserName").value((Object)rDSMetadata.getDatabaseUserName());
            }
            if (rDSMetadata.getSelectSqlQuery() != null) {
                jsonWriter.key("SelectSqlQuery").value((Object)rDSMetadata.getSelectSqlQuery());
            }
            if (rDSMetadata.getResourceRole() != null) {
                jsonWriter.key("ResourceRole").value((Object)rDSMetadata.getResourceRole());
            }
            if (rDSMetadata.getServiceRole() != null) {
                jsonWriter.key("ServiceRole").value((Object)rDSMetadata.getServiceRole());
            }
            if (rDSMetadata.getDataPipelineId() != null) {
                jsonWriter.key("DataPipelineId").value((Object)rDSMetadata.getDataPipelineId());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RDSMetadataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RDSMetadataJsonMarshaller();
        }
        return instance;
    }
}

