/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutmetrics.model.CSVFileCompression;
import com.amazonaws.services.lookoutmetrics.model.transform.CsvFormatDescriptorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CsvFormatDescriptor
implements Serializable,
Cloneable,
StructuredPojo {
    private String fileCompression;
    private String charset;
    private Boolean containsHeader;
    private String delimiter;
    private List<String> headerList;
    private String quoteSymbol;

    public void setFileCompression(String fileCompression) {
        this.fileCompression = fileCompression;
    }

    public String getFileCompression() {
        return this.fileCompression;
    }

    public CsvFormatDescriptor withFileCompression(String fileCompression) {
        this.setFileCompression(fileCompression);
        return this;
    }

    public CsvFormatDescriptor withFileCompression(CSVFileCompression fileCompression) {
        this.fileCompression = fileCompression.toString();
        return this;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public CsvFormatDescriptor withCharset(String charset) {
        this.setCharset(charset);
        return this;
    }

    public void setContainsHeader(Boolean containsHeader) {
        this.containsHeader = containsHeader;
    }

    public Boolean getContainsHeader() {
        return this.containsHeader;
    }

    public CsvFormatDescriptor withContainsHeader(Boolean containsHeader) {
        this.setContainsHeader(containsHeader);
        return this;
    }

    public Boolean isContainsHeader() {
        return this.containsHeader;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public CsvFormatDescriptor withDelimiter(String delimiter) {
        this.setDelimiter(delimiter);
        return this;
    }

    public List<String> getHeaderList() {
        return this.headerList;
    }

    public void setHeaderList(Collection<String> headerList) {
        if (headerList == null) {
            this.headerList = null;
            return;
        }
        this.headerList = new ArrayList<String>(headerList);
    }

    public CsvFormatDescriptor withHeaderList(String ... headerList) {
        if (this.headerList == null) {
            this.setHeaderList(new ArrayList<String>(headerList.length));
        }
        for (String ele : headerList) {
            this.headerList.add(ele);
        }
        return this;
    }

    public CsvFormatDescriptor withHeaderList(Collection<String> headerList) {
        this.setHeaderList(headerList);
        return this;
    }

    public void setQuoteSymbol(String quoteSymbol) {
        this.quoteSymbol = quoteSymbol;
    }

    public String getQuoteSymbol() {
        return this.quoteSymbol;
    }

    public CsvFormatDescriptor withQuoteSymbol(String quoteSymbol) {
        this.setQuoteSymbol(quoteSymbol);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileCompression() != null) {
            sb.append("FileCompression: ").append(this.getFileCompression()).append(",");
        }
        if (this.getCharset() != null) {
            sb.append("Charset: ").append(this.getCharset()).append(",");
        }
        if (this.getContainsHeader() != null) {
            sb.append("ContainsHeader: ").append(this.getContainsHeader()).append(",");
        }
        if (this.getDelimiter() != null) {
            sb.append("Delimiter: ").append(this.getDelimiter()).append(",");
        }
        if (this.getHeaderList() != null) {
            sb.append("HeaderList: ").append(this.getHeaderList()).append(",");
        }
        if (this.getQuoteSymbol() != null) {
            sb.append("QuoteSymbol: ").append(this.getQuoteSymbol());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsvFormatDescriptor)) {
            return false;
        }
        CsvFormatDescriptor other = (CsvFormatDescriptor)obj;
        if (other.getFileCompression() == null ^ this.getFileCompression() == null) {
            return false;
        }
        if (other.getFileCompression() != null && !other.getFileCompression().equals(this.getFileCompression())) {
            return false;
        }
        if (other.getCharset() == null ^ this.getCharset() == null) {
            return false;
        }
        if (other.getCharset() != null && !other.getCharset().equals(this.getCharset())) {
            return false;
        }
        if (other.getContainsHeader() == null ^ this.getContainsHeader() == null) {
            return false;
        }
        if (other.getContainsHeader() != null && !other.getContainsHeader().equals(this.getContainsHeader())) {
            return false;
        }
        if (other.getDelimiter() == null ^ this.getDelimiter() == null) {
            return false;
        }
        if (other.getDelimiter() != null && !other.getDelimiter().equals(this.getDelimiter())) {
            return false;
        }
        if (other.getHeaderList() == null ^ this.getHeaderList() == null) {
            return false;
        }
        if (other.getHeaderList() != null && !other.getHeaderList().equals(this.getHeaderList())) {
            return false;
        }
        if (other.getQuoteSymbol() == null ^ this.getQuoteSymbol() == null) {
            return false;
        }
        return other.getQuoteSymbol() == null || other.getQuoteSymbol().equals(this.getQuoteSymbol());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileCompression() == null ? 0 : this.getFileCompression().hashCode());
        hashCode = 31 * hashCode + (this.getCharset() == null ? 0 : this.getCharset().hashCode());
        hashCode = 31 * hashCode + (this.getContainsHeader() == null ? 0 : this.getContainsHeader().hashCode());
        hashCode = 31 * hashCode + (this.getDelimiter() == null ? 0 : this.getDelimiter().hashCode());
        hashCode = 31 * hashCode + (this.getHeaderList() == null ? 0 : this.getHeaderList().hashCode());
        hashCode = 31 * hashCode + (this.getQuoteSymbol() == null ? 0 : this.getQuoteSymbol().hashCode());
        return hashCode;
    }

    public CsvFormatDescriptor clone() {
        try {
            return (CsvFormatDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CsvFormatDescriptorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

