/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutequipment.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutequipment.model.CreateModelRequest;
import com.amazonaws.util.IdempotentUtils;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class CreateModelRequestMarshaller {
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelName").build();
    private static final MarshallingInfo<String> DATASETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetName").build();
    private static final MarshallingInfo<StructuredPojo> DATASETSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetSchema").build();
    private static final MarshallingInfo<StructuredPojo> LABELSINPUTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LabelsInputConfiguration").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<Date> TRAININGDATASTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingDataStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> TRAININGDATAENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingDataEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> EVALUATIONDATASTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationDataStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> EVALUATIONDATAENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationDataEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<StructuredPojo> DATAPREPROCESSINGCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataPreProcessingConfiguration").build();
    private static final MarshallingInfo<String> SERVERSIDEKMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerSideKmsKeyId").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<String> OFFCONDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OffCondition").build();
    private static final MarshallingInfo<StructuredPojo> MODELDIAGNOSTICSOUTPUTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelDiagnosticsOutputConfiguration").build();
    private static final CreateModelRequestMarshaller instance = new CreateModelRequestMarshaller();

    public static CreateModelRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(CreateModelRequest createModelRequest, ProtocolMarshaller protocolMarshaller) {
        if (createModelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createModelRequest.getModelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getDatasetName(), DATASETNAME_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getDatasetSchema(), DATASETSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getLabelsInputConfiguration(), LABELSINPUTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getClientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getTrainingDataStartTime(), TRAININGDATASTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getTrainingDataEndTime(), TRAININGDATAENDTIME_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getEvaluationDataStartTime(), EVALUATIONDATASTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getEvaluationDataEndTime(), EVALUATIONDATAENDTIME_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getDataPreProcessingConfiguration(), DATAPREPROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getServerSideKmsKeyId(), SERVERSIDEKMSKEYID_BINDING);
            protocolMarshaller.marshall(createModelRequest.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getOffCondition(), OFFCONDITION_BINDING);
            protocolMarshaller.marshall((Object)createModelRequest.getModelDiagnosticsOutputConfiguration(), MODELDIAGNOSTICSOUTPUTCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

