/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lookoutequipment.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lookoutequipment-2020-12-15/DescribeLabelGroup"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeLabelGroupResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the label group.
     * </p>
     */
    private String labelGroupName;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the label group.
     * </p>
     */
    private String labelGroupArn;
    /**
     * <p>
     * Codes indicating the type of anomaly associated with the labels in the lagbel group.
     * </p>
     */
    private java.util.List<String> faultCodes;
    /**
     * <p>
     * The time at which the label group was created.
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * The time at which the label group was updated.
     * </p>
     */
    private java.util.Date updatedAt;

    /**
     * <p>
     * The name of the label group.
     * </p>
     * 
     * @param labelGroupName
     *        The name of the label group.
     */

    public void setLabelGroupName(String labelGroupName) {
        this.labelGroupName = labelGroupName;
    }

    /**
     * <p>
     * The name of the label group.
     * </p>
     * 
     * @return The name of the label group.
     */

    public String getLabelGroupName() {
        return this.labelGroupName;
    }

    /**
     * <p>
     * The name of the label group.
     * </p>
     * 
     * @param labelGroupName
     *        The name of the label group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeLabelGroupResult withLabelGroupName(String labelGroupName) {
        setLabelGroupName(labelGroupName);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the label group.
     * </p>
     * 
     * @param labelGroupArn
     *        The Amazon Resource Name (ARN) of the label group.
     */

    public void setLabelGroupArn(String labelGroupArn) {
        this.labelGroupArn = labelGroupArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the label group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the label group.
     */

    public String getLabelGroupArn() {
        return this.labelGroupArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the label group.
     * </p>
     * 
     * @param labelGroupArn
     *        The Amazon Resource Name (ARN) of the label group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeLabelGroupResult withLabelGroupArn(String labelGroupArn) {
        setLabelGroupArn(labelGroupArn);
        return this;
    }

    /**
     * <p>
     * Codes indicating the type of anomaly associated with the labels in the lagbel group.
     * </p>
     * 
     * @return Codes indicating the type of anomaly associated with the labels in the lagbel group.
     */

    public java.util.List<String> getFaultCodes() {
        return faultCodes;
    }

    /**
     * <p>
     * Codes indicating the type of anomaly associated with the labels in the lagbel group.
     * </p>
     * 
     * @param faultCodes
     *        Codes indicating the type of anomaly associated with the labels in the lagbel group.
     */

    public void setFaultCodes(java.util.Collection<String> faultCodes) {
        if (faultCodes == null) {
            this.faultCodes = null;
            return;
        }

        this.faultCodes = new java.util.ArrayList<String>(faultCodes);
    }

    /**
     * <p>
     * Codes indicating the type of anomaly associated with the labels in the lagbel group.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFaultCodes(java.util.Collection)} or {@link #withFaultCodes(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param faultCodes
     *        Codes indicating the type of anomaly associated with the labels in the lagbel group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeLabelGroupResult withFaultCodes(String... faultCodes) {
        if (this.faultCodes == null) {
            setFaultCodes(new java.util.ArrayList<String>(faultCodes.length));
        }
        for (String ele : faultCodes) {
            this.faultCodes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Codes indicating the type of anomaly associated with the labels in the lagbel group.
     * </p>
     * 
     * @param faultCodes
     *        Codes indicating the type of anomaly associated with the labels in the lagbel group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeLabelGroupResult withFaultCodes(java.util.Collection<String> faultCodes) {
        setFaultCodes(faultCodes);
        return this;
    }

    /**
     * <p>
     * The time at which the label group was created.
     * </p>
     * 
     * @param createdAt
     *        The time at which the label group was created.
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * The time at which the label group was created.
     * </p>
     * 
     * @return The time at which the label group was created.
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * The time at which the label group was created.
     * </p>
     * 
     * @param createdAt
     *        The time at which the label group was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeLabelGroupResult withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * The time at which the label group was updated.
     * </p>
     * 
     * @param updatedAt
     *        The time at which the label group was updated.
     */

    public void setUpdatedAt(java.util.Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    /**
     * <p>
     * The time at which the label group was updated.
     * </p>
     * 
     * @return The time at which the label group was updated.
     */

    public java.util.Date getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * <p>
     * The time at which the label group was updated.
     * </p>
     * 
     * @param updatedAt
     *        The time at which the label group was updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeLabelGroupResult withUpdatedAt(java.util.Date updatedAt) {
        setUpdatedAt(updatedAt);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLabelGroupName() != null)
            sb.append("LabelGroupName: ").append(getLabelGroupName()).append(",");
        if (getLabelGroupArn() != null)
            sb.append("LabelGroupArn: ").append(getLabelGroupArn()).append(",");
        if (getFaultCodes() != null)
            sb.append("FaultCodes: ").append(getFaultCodes()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getUpdatedAt() != null)
            sb.append("UpdatedAt: ").append(getUpdatedAt());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeLabelGroupResult == false)
            return false;
        DescribeLabelGroupResult other = (DescribeLabelGroupResult) obj;
        if (other.getLabelGroupName() == null ^ this.getLabelGroupName() == null)
            return false;
        if (other.getLabelGroupName() != null && other.getLabelGroupName().equals(this.getLabelGroupName()) == false)
            return false;
        if (other.getLabelGroupArn() == null ^ this.getLabelGroupArn() == null)
            return false;
        if (other.getLabelGroupArn() != null && other.getLabelGroupArn().equals(this.getLabelGroupArn()) == false)
            return false;
        if (other.getFaultCodes() == null ^ this.getFaultCodes() == null)
            return false;
        if (other.getFaultCodes() != null && other.getFaultCodes().equals(this.getFaultCodes()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null)
            return false;
        if (other.getUpdatedAt() != null && other.getUpdatedAt().equals(this.getUpdatedAt()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLabelGroupName() == null) ? 0 : getLabelGroupName().hashCode());
        hashCode = prime * hashCode + ((getLabelGroupArn() == null) ? 0 : getLabelGroupArn().hashCode());
        hashCode = prime * hashCode + ((getFaultCodes() == null) ? 0 : getFaultCodes().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getUpdatedAt() == null) ? 0 : getUpdatedAt().hashCode());
        return hashCode;
    }

    @Override
    public DescribeLabelGroupResult clone() {
        try {
            return (DescribeLabelGroupResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
