/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.logs.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeAccountPolicies" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeAccountPoliciesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * An array of structures that contain information about the CloudWatch Logs account policies that match the
     * specified filters.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<AccountPolicy> accountPolicies;

    /**
     * <p>
     * An array of structures that contain information about the CloudWatch Logs account policies that match the
     * specified filters.
     * </p>
     * 
     * @return An array of structures that contain information about the CloudWatch Logs account policies that match the
     *         specified filters.
     */

    public java.util.List<AccountPolicy> getAccountPolicies() {
        if (accountPolicies == null) {
            accountPolicies = new com.amazonaws.internal.SdkInternalList<AccountPolicy>();
        }
        return accountPolicies;
    }

    /**
     * <p>
     * An array of structures that contain information about the CloudWatch Logs account policies that match the
     * specified filters.
     * </p>
     * 
     * @param accountPolicies
     *        An array of structures that contain information about the CloudWatch Logs account policies that match the
     *        specified filters.
     */

    public void setAccountPolicies(java.util.Collection<AccountPolicy> accountPolicies) {
        if (accountPolicies == null) {
            this.accountPolicies = null;
            return;
        }

        this.accountPolicies = new com.amazonaws.internal.SdkInternalList<AccountPolicy>(accountPolicies);
    }

    /**
     * <p>
     * An array of structures that contain information about the CloudWatch Logs account policies that match the
     * specified filters.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAccountPolicies(java.util.Collection)} or {@link #withAccountPolicies(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param accountPolicies
     *        An array of structures that contain information about the CloudWatch Logs account policies that match the
     *        specified filters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeAccountPoliciesResult withAccountPolicies(AccountPolicy... accountPolicies) {
        if (this.accountPolicies == null) {
            setAccountPolicies(new com.amazonaws.internal.SdkInternalList<AccountPolicy>(accountPolicies.length));
        }
        for (AccountPolicy ele : accountPolicies) {
            this.accountPolicies.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An array of structures that contain information about the CloudWatch Logs account policies that match the
     * specified filters.
     * </p>
     * 
     * @param accountPolicies
     *        An array of structures that contain information about the CloudWatch Logs account policies that match the
     *        specified filters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeAccountPoliciesResult withAccountPolicies(java.util.Collection<AccountPolicy> accountPolicies) {
        setAccountPolicies(accountPolicies);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccountPolicies() != null)
            sb.append("AccountPolicies: ").append(getAccountPolicies());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeAccountPoliciesResult == false)
            return false;
        DescribeAccountPoliciesResult other = (DescribeAccountPoliciesResult) obj;
        if (other.getAccountPolicies() == null ^ this.getAccountPolicies() == null)
            return false;
        if (other.getAccountPolicies() != null && other.getAccountPolicies().equals(this.getAccountPolicies()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccountPolicies() == null) ? 0 : getAccountPolicies().hashCode());
        return hashCode;
    }

    @Override
    public DescribeAccountPoliciesResult clone() {
        try {
            return (DescribeAccountPoliciesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
