/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.logs.model.transform.MetricFilterMatchRecordMarshaller;
import java.io.Serializable;
import java.util.Map;

public class MetricFilterMatchRecord
implements Serializable,
Cloneable,
StructuredPojo {
    private Long eventNumber;
    private String eventMessage;
    private SdkInternalMap<String, String> extractedValues;

    public void setEventNumber(Long eventNumber) {
        this.eventNumber = eventNumber;
    }

    public Long getEventNumber() {
        return this.eventNumber;
    }

    public MetricFilterMatchRecord withEventNumber(Long eventNumber) {
        this.setEventNumber(eventNumber);
        return this;
    }

    public void setEventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
    }

    public String getEventMessage() {
        return this.eventMessage;
    }

    public MetricFilterMatchRecord withEventMessage(String eventMessage) {
        this.setEventMessage(eventMessage);
        return this;
    }

    public Map<String, String> getExtractedValues() {
        if (this.extractedValues == null) {
            this.extractedValues = new SdkInternalMap();
        }
        return this.extractedValues;
    }

    public void setExtractedValues(Map<String, String> extractedValues) {
        this.extractedValues = extractedValues == null ? null : new SdkInternalMap(extractedValues);
    }

    public MetricFilterMatchRecord withExtractedValues(Map<String, String> extractedValues) {
        this.setExtractedValues(extractedValues);
        return this;
    }

    public MetricFilterMatchRecord addExtractedValuesEntry(String key, String value) {
        if (null == this.extractedValues) {
            this.extractedValues = new SdkInternalMap();
        }
        if (this.extractedValues.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.extractedValues.put((Object)key, (Object)value);
        return this;
    }

    public MetricFilterMatchRecord clearExtractedValuesEntries() {
        this.extractedValues = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventNumber() != null) {
            sb.append("EventNumber: ").append(this.getEventNumber()).append(",");
        }
        if (this.getEventMessage() != null) {
            sb.append("EventMessage: ").append(this.getEventMessage()).append(",");
        }
        if (this.getExtractedValues() != null) {
            sb.append("ExtractedValues: ").append(this.getExtractedValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilterMatchRecord)) {
            return false;
        }
        MetricFilterMatchRecord other = (MetricFilterMatchRecord)obj;
        if (other.getEventNumber() == null ^ this.getEventNumber() == null) {
            return false;
        }
        if (other.getEventNumber() != null && !other.getEventNumber().equals(this.getEventNumber())) {
            return false;
        }
        if (other.getEventMessage() == null ^ this.getEventMessage() == null) {
            return false;
        }
        if (other.getEventMessage() != null && !other.getEventMessage().equals(this.getEventMessage())) {
            return false;
        }
        if (other.getExtractedValues() == null ^ this.getExtractedValues() == null) {
            return false;
        }
        return other.getExtractedValues() == null || other.getExtractedValues().equals(this.getExtractedValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventNumber() == null ? 0 : this.getEventNumber().hashCode());
        hashCode = 31 * hashCode + (this.getEventMessage() == null ? 0 : this.getEventMessage().hashCode());
        hashCode = 31 * hashCode + (this.getExtractedValues() == null ? 0 : this.getExtractedValues().hashCode());
        return hashCode;
    }

    public MetricFilterMatchRecord clone() {
        try {
            return (MetricFilterMatchRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricFilterMatchRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

