/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.logs.model.FilteredLogEvent;
import com.amazonaws.services.logs.model.SearchedLogStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class FilterLogEventsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<FilteredLogEvent> events;
    private SdkInternalList<SearchedLogStream> searchedLogStreams;
    private String nextToken;

    public List<FilteredLogEvent> getEvents() {
        if (this.events == null) {
            this.events = new SdkInternalList();
        }
        return this.events;
    }

    public void setEvents(Collection<FilteredLogEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new SdkInternalList(events);
    }

    public FilterLogEventsResult withEvents(FilteredLogEvent ... events) {
        if (this.events == null) {
            this.setEvents((Collection<FilteredLogEvent>)new SdkInternalList(events.length));
        }
        for (FilteredLogEvent ele : events) {
            this.events.add((Object)ele);
        }
        return this;
    }

    public FilterLogEventsResult withEvents(Collection<FilteredLogEvent> events) {
        this.setEvents(events);
        return this;
    }

    public List<SearchedLogStream> getSearchedLogStreams() {
        if (this.searchedLogStreams == null) {
            this.searchedLogStreams = new SdkInternalList();
        }
        return this.searchedLogStreams;
    }

    public void setSearchedLogStreams(Collection<SearchedLogStream> searchedLogStreams) {
        if (searchedLogStreams == null) {
            this.searchedLogStreams = null;
            return;
        }
        this.searchedLogStreams = new SdkInternalList(searchedLogStreams);
    }

    public FilterLogEventsResult withSearchedLogStreams(SearchedLogStream ... searchedLogStreams) {
        if (this.searchedLogStreams == null) {
            this.setSearchedLogStreams((Collection<SearchedLogStream>)new SdkInternalList(searchedLogStreams.length));
        }
        for (SearchedLogStream ele : searchedLogStreams) {
            this.searchedLogStreams.add((Object)ele);
        }
        return this;
    }

    public FilterLogEventsResult withSearchedLogStreams(Collection<SearchedLogStream> searchedLogStreams) {
        this.setSearchedLogStreams(searchedLogStreams);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public FilterLogEventsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents() + ",");
        }
        if (this.getSearchedLogStreams() != null) {
            sb.append("SearchedLogStreams: " + this.getSearchedLogStreams() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsResult)) {
            return false;
        }
        FilterLogEventsResult other = (FilterLogEventsResult)obj;
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getSearchedLogStreams() == null ^ this.getSearchedLogStreams() == null) {
            return false;
        }
        if (other.getSearchedLogStreams() != null && !other.getSearchedLogStreams().equals(this.getSearchedLogStreams())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getSearchedLogStreams() == null ? 0 : this.getSearchedLogStreams().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public FilterLogEventsResult clone() {
        try {
            return (FilterLogEventsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

