/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.logs.AWSLogsAsync;
import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.logs.model.CancelExportTaskRequest;
import com.amazonaws.services.logs.model.CancelExportTaskResult;
import com.amazonaws.services.logs.model.CreateExportTaskRequest;
import com.amazonaws.services.logs.model.CreateExportTaskResult;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogGroupResult;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.CreateLogStreamResult;
import com.amazonaws.services.logs.model.DeleteDestinationRequest;
import com.amazonaws.services.logs.model.DeleteDestinationResult;
import com.amazonaws.services.logs.model.DeleteLogGroupRequest;
import com.amazonaws.services.logs.model.DeleteLogGroupResult;
import com.amazonaws.services.logs.model.DeleteLogStreamRequest;
import com.amazonaws.services.logs.model.DeleteLogStreamResult;
import com.amazonaws.services.logs.model.DeleteMetricFilterRequest;
import com.amazonaws.services.logs.model.DeleteMetricFilterResult;
import com.amazonaws.services.logs.model.DeleteRetentionPolicyRequest;
import com.amazonaws.services.logs.model.DeleteRetentionPolicyResult;
import com.amazonaws.services.logs.model.DeleteSubscriptionFilterRequest;
import com.amazonaws.services.logs.model.DeleteSubscriptionFilterResult;
import com.amazonaws.services.logs.model.DescribeDestinationsRequest;
import com.amazonaws.services.logs.model.DescribeDestinationsResult;
import com.amazonaws.services.logs.model.DescribeExportTasksRequest;
import com.amazonaws.services.logs.model.DescribeExportTasksResult;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.amazonaws.services.logs.model.DescribeMetricFiltersRequest;
import com.amazonaws.services.logs.model.DescribeMetricFiltersResult;
import com.amazonaws.services.logs.model.DescribeSubscriptionFiltersRequest;
import com.amazonaws.services.logs.model.DescribeSubscriptionFiltersResult;
import com.amazonaws.services.logs.model.FilterLogEventsRequest;
import com.amazonaws.services.logs.model.FilterLogEventsResult;
import com.amazonaws.services.logs.model.GetLogEventsRequest;
import com.amazonaws.services.logs.model.GetLogEventsResult;
import com.amazonaws.services.logs.model.PutDestinationPolicyRequest;
import com.amazonaws.services.logs.model.PutDestinationPolicyResult;
import com.amazonaws.services.logs.model.PutDestinationRequest;
import com.amazonaws.services.logs.model.PutDestinationResult;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.PutMetricFilterRequest;
import com.amazonaws.services.logs.model.PutMetricFilterResult;
import com.amazonaws.services.logs.model.PutRetentionPolicyRequest;
import com.amazonaws.services.logs.model.PutRetentionPolicyResult;
import com.amazonaws.services.logs.model.PutSubscriptionFilterRequest;
import com.amazonaws.services.logs.model.PutSubscriptionFilterResult;
import com.amazonaws.services.logs.model.TestMetricFilterRequest;
import com.amazonaws.services.logs.model.TestMetricFilterResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSLogsAsyncClient
extends AWSLogsClient
implements AWSLogsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSLogsAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSLogsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLogsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSLogsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSLogsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSLogsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSLogsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelExportTaskResult> cancelExportTaskAsync(CancelExportTaskRequest request) {
        return this.cancelExportTaskAsync(request, null);
    }

    @Override
    public Future<CancelExportTaskResult> cancelExportTaskAsync(final CancelExportTaskRequest request, final AsyncHandler<CancelExportTaskRequest, CancelExportTaskResult> asyncHandler) {
        return this.executorService.submit(new Callable<CancelExportTaskResult>(){

            @Override
            public CancelExportTaskResult call() throws Exception {
                CancelExportTaskResult result;
                try {
                    result = AWSLogsAsyncClient.this.cancelExportTask(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateExportTaskResult> createExportTaskAsync(CreateExportTaskRequest request) {
        return this.createExportTaskAsync(request, null);
    }

    @Override
    public Future<CreateExportTaskResult> createExportTaskAsync(final CreateExportTaskRequest request, final AsyncHandler<CreateExportTaskRequest, CreateExportTaskResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateExportTaskResult>(){

            @Override
            public CreateExportTaskResult call() throws Exception {
                CreateExportTaskResult result;
                try {
                    result = AWSLogsAsyncClient.this.createExportTask(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLogGroupResult> createLogGroupAsync(CreateLogGroupRequest request) {
        return this.createLogGroupAsync(request, null);
    }

    @Override
    public Future<CreateLogGroupResult> createLogGroupAsync(final CreateLogGroupRequest request, final AsyncHandler<CreateLogGroupRequest, CreateLogGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateLogGroupResult>(){

            @Override
            public CreateLogGroupResult call() throws Exception {
                CreateLogGroupResult result;
                try {
                    result = AWSLogsAsyncClient.this.createLogGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLogStreamResult> createLogStreamAsync(CreateLogStreamRequest request) {
        return this.createLogStreamAsync(request, null);
    }

    @Override
    public Future<CreateLogStreamResult> createLogStreamAsync(final CreateLogStreamRequest request, final AsyncHandler<CreateLogStreamRequest, CreateLogStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateLogStreamResult>(){

            @Override
            public CreateLogStreamResult call() throws Exception {
                CreateLogStreamResult result;
                try {
                    result = AWSLogsAsyncClient.this.createLogStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDestinationResult> deleteDestinationAsync(DeleteDestinationRequest request) {
        return this.deleteDestinationAsync(request, null);
    }

    @Override
    public Future<DeleteDestinationResult> deleteDestinationAsync(final DeleteDestinationRequest request, final AsyncHandler<DeleteDestinationRequest, DeleteDestinationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDestinationResult>(){

            @Override
            public DeleteDestinationResult call() throws Exception {
                DeleteDestinationResult result;
                try {
                    result = AWSLogsAsyncClient.this.deleteDestination(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLogGroupResult> deleteLogGroupAsync(DeleteLogGroupRequest request) {
        return this.deleteLogGroupAsync(request, null);
    }

    @Override
    public Future<DeleteLogGroupResult> deleteLogGroupAsync(final DeleteLogGroupRequest request, final AsyncHandler<DeleteLogGroupRequest, DeleteLogGroupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteLogGroupResult>(){

            @Override
            public DeleteLogGroupResult call() throws Exception {
                DeleteLogGroupResult result;
                try {
                    result = AWSLogsAsyncClient.this.deleteLogGroup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLogStreamResult> deleteLogStreamAsync(DeleteLogStreamRequest request) {
        return this.deleteLogStreamAsync(request, null);
    }

    @Override
    public Future<DeleteLogStreamResult> deleteLogStreamAsync(final DeleteLogStreamRequest request, final AsyncHandler<DeleteLogStreamRequest, DeleteLogStreamResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteLogStreamResult>(){

            @Override
            public DeleteLogStreamResult call() throws Exception {
                DeleteLogStreamResult result;
                try {
                    result = AWSLogsAsyncClient.this.deleteLogStream(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMetricFilterResult> deleteMetricFilterAsync(DeleteMetricFilterRequest request) {
        return this.deleteMetricFilterAsync(request, null);
    }

    @Override
    public Future<DeleteMetricFilterResult> deleteMetricFilterAsync(final DeleteMetricFilterRequest request, final AsyncHandler<DeleteMetricFilterRequest, DeleteMetricFilterResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteMetricFilterResult>(){

            @Override
            public DeleteMetricFilterResult call() throws Exception {
                DeleteMetricFilterResult result;
                try {
                    result = AWSLogsAsyncClient.this.deleteMetricFilter(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRetentionPolicyResult> deleteRetentionPolicyAsync(DeleteRetentionPolicyRequest request) {
        return this.deleteRetentionPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteRetentionPolicyResult> deleteRetentionPolicyAsync(final DeleteRetentionPolicyRequest request, final AsyncHandler<DeleteRetentionPolicyRequest, DeleteRetentionPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRetentionPolicyResult>(){

            @Override
            public DeleteRetentionPolicyResult call() throws Exception {
                DeleteRetentionPolicyResult result;
                try {
                    result = AWSLogsAsyncClient.this.deleteRetentionPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSubscriptionFilterResult> deleteSubscriptionFilterAsync(DeleteSubscriptionFilterRequest request) {
        return this.deleteSubscriptionFilterAsync(request, null);
    }

    @Override
    public Future<DeleteSubscriptionFilterResult> deleteSubscriptionFilterAsync(final DeleteSubscriptionFilterRequest request, final AsyncHandler<DeleteSubscriptionFilterRequest, DeleteSubscriptionFilterResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteSubscriptionFilterResult>(){

            @Override
            public DeleteSubscriptionFilterResult call() throws Exception {
                DeleteSubscriptionFilterResult result;
                try {
                    result = AWSLogsAsyncClient.this.deleteSubscriptionFilter(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDestinationsResult> describeDestinationsAsync(DescribeDestinationsRequest request) {
        return this.describeDestinationsAsync(request, null);
    }

    @Override
    public Future<DescribeDestinationsResult> describeDestinationsAsync(final DescribeDestinationsRequest request, final AsyncHandler<DescribeDestinationsRequest, DescribeDestinationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeDestinationsResult>(){

            @Override
            public DescribeDestinationsResult call() throws Exception {
                DescribeDestinationsResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeDestinations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDestinationsResult> describeDestinationsAsync() {
        return this.describeDestinationsAsync(new DescribeDestinationsRequest());
    }

    @Override
    public Future<DescribeDestinationsResult> describeDestinationsAsync(AsyncHandler<DescribeDestinationsRequest, DescribeDestinationsResult> asyncHandler) {
        return this.describeDestinationsAsync(new DescribeDestinationsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeExportTasksResult> describeExportTasksAsync(DescribeExportTasksRequest request) {
        return this.describeExportTasksAsync(request, null);
    }

    @Override
    public Future<DescribeExportTasksResult> describeExportTasksAsync(final DescribeExportTasksRequest request, final AsyncHandler<DescribeExportTasksRequest, DescribeExportTasksResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeExportTasksResult>(){

            @Override
            public DescribeExportTasksResult call() throws Exception {
                DescribeExportTasksResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeExportTasks(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLogGroupsResult> describeLogGroupsAsync(DescribeLogGroupsRequest request) {
        return this.describeLogGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeLogGroupsResult> describeLogGroupsAsync(final DescribeLogGroupsRequest request, final AsyncHandler<DescribeLogGroupsRequest, DescribeLogGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLogGroupsResult>(){

            @Override
            public DescribeLogGroupsResult call() throws Exception {
                DescribeLogGroupsResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeLogGroups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLogGroupsResult> describeLogGroupsAsync() {
        return this.describeLogGroupsAsync(new DescribeLogGroupsRequest());
    }

    @Override
    public Future<DescribeLogGroupsResult> describeLogGroupsAsync(AsyncHandler<DescribeLogGroupsRequest, DescribeLogGroupsResult> asyncHandler) {
        return this.describeLogGroupsAsync(new DescribeLogGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLogStreamsResult> describeLogStreamsAsync(DescribeLogStreamsRequest request) {
        return this.describeLogStreamsAsync(request, null);
    }

    @Override
    public Future<DescribeLogStreamsResult> describeLogStreamsAsync(final DescribeLogStreamsRequest request, final AsyncHandler<DescribeLogStreamsRequest, DescribeLogStreamsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLogStreamsResult>(){

            @Override
            public DescribeLogStreamsResult call() throws Exception {
                DescribeLogStreamsResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeLogStreams(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMetricFiltersResult> describeMetricFiltersAsync(DescribeMetricFiltersRequest request) {
        return this.describeMetricFiltersAsync(request, null);
    }

    @Override
    public Future<DescribeMetricFiltersResult> describeMetricFiltersAsync(final DescribeMetricFiltersRequest request, final AsyncHandler<DescribeMetricFiltersRequest, DescribeMetricFiltersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeMetricFiltersResult>(){

            @Override
            public DescribeMetricFiltersResult call() throws Exception {
                DescribeMetricFiltersResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeMetricFilters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSubscriptionFiltersResult> describeSubscriptionFiltersAsync(DescribeSubscriptionFiltersRequest request) {
        return this.describeSubscriptionFiltersAsync(request, null);
    }

    @Override
    public Future<DescribeSubscriptionFiltersResult> describeSubscriptionFiltersAsync(final DescribeSubscriptionFiltersRequest request, final AsyncHandler<DescribeSubscriptionFiltersRequest, DescribeSubscriptionFiltersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeSubscriptionFiltersResult>(){

            @Override
            public DescribeSubscriptionFiltersResult call() throws Exception {
                DescribeSubscriptionFiltersResult result;
                try {
                    result = AWSLogsAsyncClient.this.describeSubscriptionFilters(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<FilterLogEventsResult> filterLogEventsAsync(FilterLogEventsRequest request) {
        return this.filterLogEventsAsync(request, null);
    }

    @Override
    public Future<FilterLogEventsResult> filterLogEventsAsync(final FilterLogEventsRequest request, final AsyncHandler<FilterLogEventsRequest, FilterLogEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<FilterLogEventsResult>(){

            @Override
            public FilterLogEventsResult call() throws Exception {
                FilterLogEventsResult result;
                try {
                    result = AWSLogsAsyncClient.this.filterLogEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLogEventsResult> getLogEventsAsync(GetLogEventsRequest request) {
        return this.getLogEventsAsync(request, null);
    }

    @Override
    public Future<GetLogEventsResult> getLogEventsAsync(final GetLogEventsRequest request, final AsyncHandler<GetLogEventsRequest, GetLogEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetLogEventsResult>(){

            @Override
            public GetLogEventsResult call() throws Exception {
                GetLogEventsResult result;
                try {
                    result = AWSLogsAsyncClient.this.getLogEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutDestinationResult> putDestinationAsync(PutDestinationRequest request) {
        return this.putDestinationAsync(request, null);
    }

    @Override
    public Future<PutDestinationResult> putDestinationAsync(final PutDestinationRequest request, final AsyncHandler<PutDestinationRequest, PutDestinationResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutDestinationResult>(){

            @Override
            public PutDestinationResult call() throws Exception {
                PutDestinationResult result;
                try {
                    result = AWSLogsAsyncClient.this.putDestination(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutDestinationPolicyResult> putDestinationPolicyAsync(PutDestinationPolicyRequest request) {
        return this.putDestinationPolicyAsync(request, null);
    }

    @Override
    public Future<PutDestinationPolicyResult> putDestinationPolicyAsync(final PutDestinationPolicyRequest request, final AsyncHandler<PutDestinationPolicyRequest, PutDestinationPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutDestinationPolicyResult>(){

            @Override
            public PutDestinationPolicyResult call() throws Exception {
                PutDestinationPolicyResult result;
                try {
                    result = AWSLogsAsyncClient.this.putDestinationPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLogEventsResult> putLogEventsAsync(PutLogEventsRequest request) {
        return this.putLogEventsAsync(request, null);
    }

    @Override
    public Future<PutLogEventsResult> putLogEventsAsync(final PutLogEventsRequest request, final AsyncHandler<PutLogEventsRequest, PutLogEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutLogEventsResult>(){

            @Override
            public PutLogEventsResult call() throws Exception {
                PutLogEventsResult result;
                try {
                    result = AWSLogsAsyncClient.this.putLogEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutMetricFilterResult> putMetricFilterAsync(PutMetricFilterRequest request) {
        return this.putMetricFilterAsync(request, null);
    }

    @Override
    public Future<PutMetricFilterResult> putMetricFilterAsync(final PutMetricFilterRequest request, final AsyncHandler<PutMetricFilterRequest, PutMetricFilterResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutMetricFilterResult>(){

            @Override
            public PutMetricFilterResult call() throws Exception {
                PutMetricFilterResult result;
                try {
                    result = AWSLogsAsyncClient.this.putMetricFilter(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRetentionPolicyResult> putRetentionPolicyAsync(PutRetentionPolicyRequest request) {
        return this.putRetentionPolicyAsync(request, null);
    }

    @Override
    public Future<PutRetentionPolicyResult> putRetentionPolicyAsync(final PutRetentionPolicyRequest request, final AsyncHandler<PutRetentionPolicyRequest, PutRetentionPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutRetentionPolicyResult>(){

            @Override
            public PutRetentionPolicyResult call() throws Exception {
                PutRetentionPolicyResult result;
                try {
                    result = AWSLogsAsyncClient.this.putRetentionPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutSubscriptionFilterResult> putSubscriptionFilterAsync(PutSubscriptionFilterRequest request) {
        return this.putSubscriptionFilterAsync(request, null);
    }

    @Override
    public Future<PutSubscriptionFilterResult> putSubscriptionFilterAsync(final PutSubscriptionFilterRequest request, final AsyncHandler<PutSubscriptionFilterRequest, PutSubscriptionFilterResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutSubscriptionFilterResult>(){

            @Override
            public PutSubscriptionFilterResult call() throws Exception {
                PutSubscriptionFilterResult result;
                try {
                    result = AWSLogsAsyncClient.this.putSubscriptionFilter(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestMetricFilterResult> testMetricFilterAsync(TestMetricFilterRequest request) {
        return this.testMetricFilterAsync(request, null);
    }

    @Override
    public Future<TestMetricFilterResult> testMetricFilterAsync(final TestMetricFilterRequest request, final AsyncHandler<TestMetricFilterRequest, TestMetricFilterResult> asyncHandler) {
        return this.executorService.submit(new Callable<TestMetricFilterResult>(){

            @Override
            public TestMetricFilterResult call() throws Exception {
                TestMetricFilterResult result;
                try {
                    result = AWSLogsAsyncClient.this.testMetricFilter(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

