/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.transform.InputLogEventJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutLogEventsRequestMarshaller
implements Marshaller<Request<PutLogEventsRequest>, PutLogEventsRequest> {
    public Request<PutLogEventsRequest> marshall(PutLogEventsRequest putLogEventsRequest) {
        if (putLogEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putLogEventsRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.PutLogEvents");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList logEventsList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (putLogEventsRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(putLogEventsRequest.getLogGroupName());
            }
            if (putLogEventsRequest.getLogStreamName() != null) {
                jsonGenerator.writeFieldName("logStreamName").writeValue(putLogEventsRequest.getLogStreamName());
            }
            if (!(logEventsList = (SdkInternalList)putLogEventsRequest.getLogEvents()).isEmpty() || !logEventsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("logEvents");
                jsonGenerator.writeStartArray();
                for (InputLogEvent logEventsListValue : logEventsList) {
                    if (logEventsListValue == null) continue;
                    InputLogEventJsonMarshaller.getInstance().marshall(logEventsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (putLogEventsRequest.getSequenceToken() != null) {
                jsonGenerator.writeFieldName("sequenceToken").writeValue(putLogEventsRequest.getSequenceToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

