/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.logs.model.MetricFilter;
import com.amazonaws.services.logs.model.MetricTransformation;
import com.amazonaws.services.logs.model.transform.MetricTransformationJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class MetricFilterJsonMarshaller {
    private static MetricFilterJsonMarshaller instance;

    public void marshall(MetricFilter metricFilter, SdkJsonGenerator jsonGenerator) {
        if (metricFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList metricTransformationsList;
            jsonGenerator.writeStartObject();
            if (metricFilter.getFilterName() != null) {
                jsonGenerator.writeFieldName("filterName").writeValue(metricFilter.getFilterName());
            }
            if (metricFilter.getFilterPattern() != null) {
                jsonGenerator.writeFieldName("filterPattern").writeValue(metricFilter.getFilterPattern());
            }
            if (!(metricTransformationsList = (SdkInternalList)metricFilter.getMetricTransformations()).isEmpty() || !metricTransformationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("metricTransformations");
                jsonGenerator.writeStartArray();
                for (MetricTransformation metricTransformationsListValue : metricTransformationsList) {
                    if (metricTransformationsListValue == null) continue;
                    MetricTransformationJsonMarshaller.getInstance().marshall(metricTransformationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (metricFilter.getCreationTime() != null) {
                jsonGenerator.writeFieldName("creationTime").writeValue(metricFilter.getCreationTime().longValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MetricFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MetricFilterJsonMarshaller();
        }
        return instance;
    }
}

