/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeLogStreamsRequestMarshaller
implements Marshaller<Request<DescribeLogStreamsRequest>, DescribeLogStreamsRequest> {
    public Request<DescribeLogStreamsRequest> marshall(DescribeLogStreamsRequest describeLogStreamsRequest) {
        if (describeLogStreamsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLogStreamsRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.DescribeLogStreams");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (describeLogStreamsRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(describeLogStreamsRequest.getLogGroupName());
            }
            if (describeLogStreamsRequest.getLogStreamNamePrefix() != null) {
                jsonGenerator.writeFieldName("logStreamNamePrefix").writeValue(describeLogStreamsRequest.getLogStreamNamePrefix());
            }
            if (describeLogStreamsRequest.getOrderBy() != null) {
                jsonGenerator.writeFieldName("orderBy").writeValue(describeLogStreamsRequest.getOrderBy());
            }
            if (describeLogStreamsRequest.getDescending() != null) {
                jsonGenerator.writeFieldName("descending").writeValue(describeLogStreamsRequest.getDescending().booleanValue());
            }
            if (describeLogStreamsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeLogStreamsRequest.getNextToken());
            }
            if (describeLogStreamsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue((long)describeLogStreamsRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

