/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.CertificateProvider;
import com.amazonaws.services.lightsail.model.transform.SetupRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SetupRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceName;
    private List<String> domainNames;
    private String certificateProvider;

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public SetupRequest withInstanceName(String instanceName) {
        this.setInstanceName(instanceName);
        return this;
    }

    public List<String> getDomainNames() {
        return this.domainNames;
    }

    public void setDomainNames(Collection<String> domainNames) {
        if (domainNames == null) {
            this.domainNames = null;
            return;
        }
        this.domainNames = new ArrayList<String>(domainNames);
    }

    public SetupRequest withDomainNames(String ... domainNames) {
        if (this.domainNames == null) {
            this.setDomainNames(new ArrayList<String>(domainNames.length));
        }
        for (String ele : domainNames) {
            this.domainNames.add(ele);
        }
        return this;
    }

    public SetupRequest withDomainNames(Collection<String> domainNames) {
        this.setDomainNames(domainNames);
        return this;
    }

    public void setCertificateProvider(String certificateProvider) {
        this.certificateProvider = certificateProvider;
    }

    public String getCertificateProvider() {
        return this.certificateProvider;
    }

    public SetupRequest withCertificateProvider(String certificateProvider) {
        this.setCertificateProvider(certificateProvider);
        return this;
    }

    public SetupRequest withCertificateProvider(CertificateProvider certificateProvider) {
        this.certificateProvider = certificateProvider.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceName() != null) {
            sb.append("InstanceName: ").append(this.getInstanceName()).append(",");
        }
        if (this.getDomainNames() != null) {
            sb.append("DomainNames: ").append(this.getDomainNames()).append(",");
        }
        if (this.getCertificateProvider() != null) {
            sb.append("CertificateProvider: ").append(this.getCertificateProvider());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetupRequest)) {
            return false;
        }
        SetupRequest other = (SetupRequest)obj;
        if (other.getInstanceName() == null ^ this.getInstanceName() == null) {
            return false;
        }
        if (other.getInstanceName() != null && !other.getInstanceName().equals(this.getInstanceName())) {
            return false;
        }
        if (other.getDomainNames() == null ^ this.getDomainNames() == null) {
            return false;
        }
        if (other.getDomainNames() != null && !other.getDomainNames().equals(this.getDomainNames())) {
            return false;
        }
        if (other.getCertificateProvider() == null ^ this.getCertificateProvider() == null) {
            return false;
        }
        return other.getCertificateProvider() == null || other.getCertificateProvider().equals(this.getCertificateProvider());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceName() == null ? 0 : this.getInstanceName().hashCode());
        hashCode = 31 * hashCode + (this.getDomainNames() == null ? 0 : this.getDomainNames().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateProvider() == null ? 0 : this.getCertificateProvider().hashCode());
        return hashCode;
    }

    public SetupRequest clone() {
        try {
            return (SetupRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SetupRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

