/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.Container;
import com.amazonaws.services.lightsail.model.EndpointRequest;
import com.amazonaws.services.lightsail.model.transform.ContainerServiceDeploymentRequestMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ContainerServiceDeploymentRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, Container> containers;
    private EndpointRequest publicEndpoint;

    public Map<String, Container> getContainers() {
        return this.containers;
    }

    public void setContainers(Map<String, Container> containers) {
        this.containers = containers;
    }

    public ContainerServiceDeploymentRequest withContainers(Map<String, Container> containers) {
        this.setContainers(containers);
        return this;
    }

    public ContainerServiceDeploymentRequest addContainersEntry(String key, Container value) {
        if (null == this.containers) {
            this.containers = new HashMap<String, Container>();
        }
        if (this.containers.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.containers.put(key, value);
        return this;
    }

    public ContainerServiceDeploymentRequest clearContainersEntries() {
        this.containers = null;
        return this;
    }

    public void setPublicEndpoint(EndpointRequest publicEndpoint) {
        this.publicEndpoint = publicEndpoint;
    }

    public EndpointRequest getPublicEndpoint() {
        return this.publicEndpoint;
    }

    public ContainerServiceDeploymentRequest withPublicEndpoint(EndpointRequest publicEndpoint) {
        this.setPublicEndpoint(publicEndpoint);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainers() != null) {
            sb.append("Containers: ").append(this.getContainers()).append(",");
        }
        if (this.getPublicEndpoint() != null) {
            sb.append("PublicEndpoint: ").append(this.getPublicEndpoint());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceDeploymentRequest)) {
            return false;
        }
        ContainerServiceDeploymentRequest other = (ContainerServiceDeploymentRequest)obj;
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getPublicEndpoint() == null ^ this.getPublicEndpoint() == null) {
            return false;
        }
        return other.getPublicEndpoint() == null || other.getPublicEndpoint().equals(this.getPublicEndpoint());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getPublicEndpoint() == null ? 0 : this.getPublicEndpoint().hashCode());
        return hashCode;
    }

    public ContainerServiceDeploymentRequest clone() {
        try {
            return (ContainerServiceDeploymentRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerServiceDeploymentRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

