/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lightsail.model.AccountLevelBpaSync;
import com.amazonaws.services.lightsail.model.Bucket;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetBucketsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Bucket> buckets;
    private String nextPageToken;
    private AccountLevelBpaSync accountLevelBpaSync;

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(Collection<Bucket> buckets) {
        if (buckets == null) {
            this.buckets = null;
            return;
        }
        this.buckets = new ArrayList<Bucket>(buckets);
    }

    public GetBucketsResult withBuckets(Bucket ... buckets) {
        if (this.buckets == null) {
            this.setBuckets(new ArrayList<Bucket>(buckets.length));
        }
        for (Bucket ele : buckets) {
            this.buckets.add(ele);
        }
        return this;
    }

    public GetBucketsResult withBuckets(Collection<Bucket> buckets) {
        this.setBuckets(buckets);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public GetBucketsResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public void setAccountLevelBpaSync(AccountLevelBpaSync accountLevelBpaSync) {
        this.accountLevelBpaSync = accountLevelBpaSync;
    }

    public AccountLevelBpaSync getAccountLevelBpaSync() {
        return this.accountLevelBpaSync;
    }

    public GetBucketsResult withAccountLevelBpaSync(AccountLevelBpaSync accountLevelBpaSync) {
        this.setAccountLevelBpaSync(accountLevelBpaSync);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBuckets() != null) {
            sb.append("Buckets: ").append(this.getBuckets()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken()).append(",");
        }
        if (this.getAccountLevelBpaSync() != null) {
            sb.append("AccountLevelBpaSync: ").append(this.getAccountLevelBpaSync());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketsResult)) {
            return false;
        }
        GetBucketsResult other = (GetBucketsResult)obj;
        if (other.getBuckets() == null ^ this.getBuckets() == null) {
            return false;
        }
        if (other.getBuckets() != null && !other.getBuckets().equals(this.getBuckets())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        if (other.getNextPageToken() != null && !other.getNextPageToken().equals(this.getNextPageToken())) {
            return false;
        }
        if (other.getAccountLevelBpaSync() == null ^ this.getAccountLevelBpaSync() == null) {
            return false;
        }
        return other.getAccountLevelBpaSync() == null || other.getAccountLevelBpaSync().equals(this.getAccountLevelBpaSync());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBuckets() == null ? 0 : this.getBuckets().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        hashCode = 31 * hashCode + (this.getAccountLevelBpaSync() == null ? 0 : this.getAccountLevelBpaSync().hashCode());
        return hashCode;
    }

    public GetBucketsResult clone() {
        try {
            return (GetBucketsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

