/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.NetworkProtocol;
import com.amazonaws.services.lightsail.model.transform.PortInfoMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PortInfo
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer fromPort;
    private Integer toPort;
    private String protocol;
    private List<String> cidrs;
    private List<String> ipv6Cidrs;
    private List<String> cidrListAliases;

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public PortInfo withFromPort(Integer fromPort) {
        this.setFromPort(fromPort);
        return this;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public PortInfo withToPort(Integer toPort) {
        this.setToPort(toPort);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public PortInfo withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public void setProtocol(NetworkProtocol protocol) {
        this.withProtocol(protocol);
    }

    public PortInfo withProtocol(NetworkProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public List<String> getCidrs() {
        return this.cidrs;
    }

    public void setCidrs(Collection<String> cidrs) {
        if (cidrs == null) {
            this.cidrs = null;
            return;
        }
        this.cidrs = new ArrayList<String>(cidrs);
    }

    public PortInfo withCidrs(String ... cidrs) {
        if (this.cidrs == null) {
            this.setCidrs(new ArrayList<String>(cidrs.length));
        }
        for (String ele : cidrs) {
            this.cidrs.add(ele);
        }
        return this;
    }

    public PortInfo withCidrs(Collection<String> cidrs) {
        this.setCidrs(cidrs);
        return this;
    }

    public List<String> getIpv6Cidrs() {
        return this.ipv6Cidrs;
    }

    public void setIpv6Cidrs(Collection<String> ipv6Cidrs) {
        if (ipv6Cidrs == null) {
            this.ipv6Cidrs = null;
            return;
        }
        this.ipv6Cidrs = new ArrayList<String>(ipv6Cidrs);
    }

    public PortInfo withIpv6Cidrs(String ... ipv6Cidrs) {
        if (this.ipv6Cidrs == null) {
            this.setIpv6Cidrs(new ArrayList<String>(ipv6Cidrs.length));
        }
        for (String ele : ipv6Cidrs) {
            this.ipv6Cidrs.add(ele);
        }
        return this;
    }

    public PortInfo withIpv6Cidrs(Collection<String> ipv6Cidrs) {
        this.setIpv6Cidrs(ipv6Cidrs);
        return this;
    }

    public List<String> getCidrListAliases() {
        return this.cidrListAliases;
    }

    public void setCidrListAliases(Collection<String> cidrListAliases) {
        if (cidrListAliases == null) {
            this.cidrListAliases = null;
            return;
        }
        this.cidrListAliases = new ArrayList<String>(cidrListAliases);
    }

    public PortInfo withCidrListAliases(String ... cidrListAliases) {
        if (this.cidrListAliases == null) {
            this.setCidrListAliases(new ArrayList<String>(cidrListAliases.length));
        }
        for (String ele : cidrListAliases) {
            this.cidrListAliases.add(ele);
        }
        return this;
    }

    public PortInfo withCidrListAliases(Collection<String> cidrListAliases) {
        this.setCidrListAliases(cidrListAliases);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFromPort() != null) {
            sb.append("FromPort: ").append(this.getFromPort()).append(",");
        }
        if (this.getToPort() != null) {
            sb.append("ToPort: ").append(this.getToPort()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getCidrs() != null) {
            sb.append("Cidrs: ").append(this.getCidrs()).append(",");
        }
        if (this.getIpv6Cidrs() != null) {
            sb.append("Ipv6Cidrs: ").append(this.getIpv6Cidrs()).append(",");
        }
        if (this.getCidrListAliases() != null) {
            sb.append("CidrListAliases: ").append(this.getCidrListAliases());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortInfo)) {
            return false;
        }
        PortInfo other = (PortInfo)obj;
        if (other.getFromPort() == null ^ this.getFromPort() == null) {
            return false;
        }
        if (other.getFromPort() != null && !other.getFromPort().equals(this.getFromPort())) {
            return false;
        }
        if (other.getToPort() == null ^ this.getToPort() == null) {
            return false;
        }
        if (other.getToPort() != null && !other.getToPort().equals(this.getToPort())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getCidrs() == null ^ this.getCidrs() == null) {
            return false;
        }
        if (other.getCidrs() != null && !other.getCidrs().equals(this.getCidrs())) {
            return false;
        }
        if (other.getIpv6Cidrs() == null ^ this.getIpv6Cidrs() == null) {
            return false;
        }
        if (other.getIpv6Cidrs() != null && !other.getIpv6Cidrs().equals(this.getIpv6Cidrs())) {
            return false;
        }
        if (other.getCidrListAliases() == null ^ this.getCidrListAliases() == null) {
            return false;
        }
        return other.getCidrListAliases() == null || other.getCidrListAliases().equals(this.getCidrListAliases());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFromPort() == null ? 0 : this.getFromPort().hashCode());
        hashCode = 31 * hashCode + (this.getToPort() == null ? 0 : this.getToPort().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getCidrs() == null ? 0 : this.getCidrs().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6Cidrs() == null ? 0 : this.getIpv6Cidrs().hashCode());
        hashCode = 31 * hashCode + (this.getCidrListAliases() == null ? 0 : this.getCidrListAliases().hashCode());
        return hashCode;
    }

    public PortInfo clone() {
        try {
            return (PortInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PortInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

