/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.HostKeyAttributes;
import java.util.Date;

@SdkInternalApi
public class HostKeyAttributesMarshaller {
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithm").build();
    private static final MarshallingInfo<String> PUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicKey").build();
    private static final MarshallingInfo<Date> WITNESSEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("witnessedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> FINGERPRINTSHA1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fingerprintSHA1").build();
    private static final MarshallingInfo<String> FINGERPRINTSHA256_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fingerprintSHA256").build();
    private static final MarshallingInfo<Date> NOTVALIDBEFORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notValidBefore").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> NOTVALIDAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notValidAfter").timestampFormat("unixTimestamp").build();
    private static final HostKeyAttributesMarshaller instance = new HostKeyAttributesMarshaller();

    public static HostKeyAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(HostKeyAttributes hostKeyAttributes, ProtocolMarshaller protocolMarshaller) {
        if (hostKeyAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hostKeyAttributes.getAlgorithm(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)hostKeyAttributes.getPublicKey(), PUBLICKEY_BINDING);
            protocolMarshaller.marshall((Object)hostKeyAttributes.getWitnessedAt(), WITNESSEDAT_BINDING);
            protocolMarshaller.marshall((Object)hostKeyAttributes.getFingerprintSHA1(), FINGERPRINTSHA1_BINDING);
            protocolMarshaller.marshall((Object)hostKeyAttributes.getFingerprintSHA256(), FINGERPRINTSHA256_BINDING);
            protocolMarshaller.marshall((Object)hostKeyAttributes.getNotValidBefore(), NOTVALIDBEFORE_BINDING);
            protocolMarshaller.marshall((Object)hostKeyAttributes.getNotValidAfter(), NOTVALIDAFTER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

