/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.transform.HostKeyAttributesMarshaller;
import java.io.Serializable;
import java.util.Date;

public class HostKeyAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithm;
    private String publicKey;
    private Date witnessedAt;
    private String fingerprintSHA1;
    private String fingerprintSHA256;
    private Date notValidBefore;
    private Date notValidAfter;

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public HostKeyAttributes withAlgorithm(String algorithm) {
        this.setAlgorithm(algorithm);
        return this;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public HostKeyAttributes withPublicKey(String publicKey) {
        this.setPublicKey(publicKey);
        return this;
    }

    public void setWitnessedAt(Date witnessedAt) {
        this.witnessedAt = witnessedAt;
    }

    public Date getWitnessedAt() {
        return this.witnessedAt;
    }

    public HostKeyAttributes withWitnessedAt(Date witnessedAt) {
        this.setWitnessedAt(witnessedAt);
        return this;
    }

    public void setFingerprintSHA1(String fingerprintSHA1) {
        this.fingerprintSHA1 = fingerprintSHA1;
    }

    public String getFingerprintSHA1() {
        return this.fingerprintSHA1;
    }

    public HostKeyAttributes withFingerprintSHA1(String fingerprintSHA1) {
        this.setFingerprintSHA1(fingerprintSHA1);
        return this;
    }

    public void setFingerprintSHA256(String fingerprintSHA256) {
        this.fingerprintSHA256 = fingerprintSHA256;
    }

    public String getFingerprintSHA256() {
        return this.fingerprintSHA256;
    }

    public HostKeyAttributes withFingerprintSHA256(String fingerprintSHA256) {
        this.setFingerprintSHA256(fingerprintSHA256);
        return this;
    }

    public void setNotValidBefore(Date notValidBefore) {
        this.notValidBefore = notValidBefore;
    }

    public Date getNotValidBefore() {
        return this.notValidBefore;
    }

    public HostKeyAttributes withNotValidBefore(Date notValidBefore) {
        this.setNotValidBefore(notValidBefore);
        return this;
    }

    public void setNotValidAfter(Date notValidAfter) {
        this.notValidAfter = notValidAfter;
    }

    public Date getNotValidAfter() {
        return this.notValidAfter;
    }

    public HostKeyAttributes withNotValidAfter(Date notValidAfter) {
        this.setNotValidAfter(notValidAfter);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithm() != null) {
            sb.append("Algorithm: ").append(this.getAlgorithm()).append(",");
        }
        if (this.getPublicKey() != null) {
            sb.append("PublicKey: ").append(this.getPublicKey()).append(",");
        }
        if (this.getWitnessedAt() != null) {
            sb.append("WitnessedAt: ").append(this.getWitnessedAt()).append(",");
        }
        if (this.getFingerprintSHA1() != null) {
            sb.append("FingerprintSHA1: ").append(this.getFingerprintSHA1()).append(",");
        }
        if (this.getFingerprintSHA256() != null) {
            sb.append("FingerprintSHA256: ").append(this.getFingerprintSHA256()).append(",");
        }
        if (this.getNotValidBefore() != null) {
            sb.append("NotValidBefore: ").append(this.getNotValidBefore()).append(",");
        }
        if (this.getNotValidAfter() != null) {
            sb.append("NotValidAfter: ").append(this.getNotValidAfter());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostKeyAttributes)) {
            return false;
        }
        HostKeyAttributes other = (HostKeyAttributes)obj;
        if (other.getAlgorithm() == null ^ this.getAlgorithm() == null) {
            return false;
        }
        if (other.getAlgorithm() != null && !other.getAlgorithm().equals(this.getAlgorithm())) {
            return false;
        }
        if (other.getPublicKey() == null ^ this.getPublicKey() == null) {
            return false;
        }
        if (other.getPublicKey() != null && !other.getPublicKey().equals(this.getPublicKey())) {
            return false;
        }
        if (other.getWitnessedAt() == null ^ this.getWitnessedAt() == null) {
            return false;
        }
        if (other.getWitnessedAt() != null && !other.getWitnessedAt().equals(this.getWitnessedAt())) {
            return false;
        }
        if (other.getFingerprintSHA1() == null ^ this.getFingerprintSHA1() == null) {
            return false;
        }
        if (other.getFingerprintSHA1() != null && !other.getFingerprintSHA1().equals(this.getFingerprintSHA1())) {
            return false;
        }
        if (other.getFingerprintSHA256() == null ^ this.getFingerprintSHA256() == null) {
            return false;
        }
        if (other.getFingerprintSHA256() != null && !other.getFingerprintSHA256().equals(this.getFingerprintSHA256())) {
            return false;
        }
        if (other.getNotValidBefore() == null ^ this.getNotValidBefore() == null) {
            return false;
        }
        if (other.getNotValidBefore() != null && !other.getNotValidBefore().equals(this.getNotValidBefore())) {
            return false;
        }
        if (other.getNotValidAfter() == null ^ this.getNotValidAfter() == null) {
            return false;
        }
        return other.getNotValidAfter() == null || other.getNotValidAfter().equals(this.getNotValidAfter());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithm() == null ? 0 : this.getAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getPublicKey() == null ? 0 : this.getPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.getWitnessedAt() == null ? 0 : this.getWitnessedAt().hashCode());
        hashCode = 31 * hashCode + (this.getFingerprintSHA1() == null ? 0 : this.getFingerprintSHA1().hashCode());
        hashCode = 31 * hashCode + (this.getFingerprintSHA256() == null ? 0 : this.getFingerprintSHA256().hashCode());
        hashCode = 31 * hashCode + (this.getNotValidBefore() == null ? 0 : this.getNotValidBefore().hashCode());
        hashCode = 31 * hashCode + (this.getNotValidAfter() == null ? 0 : this.getNotValidAfter().hashCode());
        return hashCode;
    }

    public HostKeyAttributes clone() {
        try {
            return (HostKeyAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HostKeyAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

