/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.Alarm;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class AlarmMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").build();
    private static final MarshallingInfo<StructuredPojo> MONITOREDRESOURCEINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("monitoredResourceInfo").build();
    private static final MarshallingInfo<String> COMPARISONOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("comparisonOperator").build();
    private static final MarshallingInfo<Integer> EVALUATIONPERIODS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("evaluationPeriods").build();
    private static final MarshallingInfo<Integer> PERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("period").build();
    private static final MarshallingInfo<Double> THRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("threshold").build();
    private static final MarshallingInfo<Integer> DATAPOINTSTOALARM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("datapointsToAlarm").build();
    private static final MarshallingInfo<String> TREATMISSINGDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("treatMissingData").build();
    private static final MarshallingInfo<String> STATISTIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statistic").build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricName").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unit").build();
    private static final MarshallingInfo<List> CONTACTPROTOCOLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contactProtocols").build();
    private static final MarshallingInfo<List> NOTIFICATIONTRIGGERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notificationTriggers").build();
    private static final MarshallingInfo<Boolean> NOTIFICATIONENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notificationEnabled").build();
    private static final AlarmMarshaller instance = new AlarmMarshaller();

    public static AlarmMarshaller getInstance() {
        return instance;
    }

    public void marshall(Alarm alarm, ProtocolMarshaller protocolMarshaller) {
        if (alarm == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)alarm.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)alarm.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)alarm.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)alarm.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)alarm.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)alarm.getSupportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall((Object)alarm.getMonitoredResourceInfo(), MONITOREDRESOURCEINFO_BINDING);
            protocolMarshaller.marshall((Object)alarm.getComparisonOperator(), COMPARISONOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)alarm.getEvaluationPeriods(), EVALUATIONPERIODS_BINDING);
            protocolMarshaller.marshall((Object)alarm.getPeriod(), PERIOD_BINDING);
            protocolMarshaller.marshall((Object)alarm.getThreshold(), THRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)alarm.getDatapointsToAlarm(), DATAPOINTSTOALARM_BINDING);
            protocolMarshaller.marshall((Object)alarm.getTreatMissingData(), TREATMISSINGDATA_BINDING);
            protocolMarshaller.marshall((Object)alarm.getStatistic(), STATISTIC_BINDING);
            protocolMarshaller.marshall((Object)alarm.getMetricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall((Object)alarm.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)alarm.getUnit(), UNIT_BINDING);
            protocolMarshaller.marshall(alarm.getContactProtocols(), CONTACTPROTOCOLS_BINDING);
            protocolMarshaller.marshall(alarm.getNotificationTriggers(), NOTIFICATIONTRIGGERS_BINDING);
            protocolMarshaller.marshall((Object)alarm.getNotificationEnabled(), NOTIFICATIONENABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

