/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.Blueprint;

public class BlueprintJsonMarshaller {
    private static BlueprintJsonMarshaller instance;

    public void marshall(Blueprint blueprint, StructuredJsonGenerator jsonGenerator) {
        if (blueprint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (blueprint.getBlueprintId() != null) {
                jsonGenerator.writeFieldName("blueprintId").writeValue(blueprint.getBlueprintId());
            }
            if (blueprint.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(blueprint.getName());
            }
            if (blueprint.getGroup() != null) {
                jsonGenerator.writeFieldName("group").writeValue(blueprint.getGroup());
            }
            if (blueprint.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(blueprint.getType());
            }
            if (blueprint.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(blueprint.getDescription());
            }
            if (blueprint.getIsActive() != null) {
                jsonGenerator.writeFieldName("isActive").writeValue(blueprint.getIsActive().booleanValue());
            }
            if (blueprint.getMinPower() != null) {
                jsonGenerator.writeFieldName("minPower").writeValue(blueprint.getMinPower().intValue());
            }
            if (blueprint.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(blueprint.getVersion());
            }
            if (blueprint.getVersionCode() != null) {
                jsonGenerator.writeFieldName("versionCode").writeValue(blueprint.getVersionCode());
            }
            if (blueprint.getProductUrl() != null) {
                jsonGenerator.writeFieldName("productUrl").writeValue(blueprint.getProductUrl());
            }
            if (blueprint.getLicenseUrl() != null) {
                jsonGenerator.writeFieldName("licenseUrl").writeValue(blueprint.getLicenseUrl());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BlueprintJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BlueprintJsonMarshaller();
        }
        return instance;
    }
}

