/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.Disk;
import com.amazonaws.services.lightsail.model.InstanceHardware;
import com.amazonaws.services.lightsail.model.transform.DiskJsonMarshaller;
import java.util.List;

public class InstanceHardwareJsonMarshaller {
    private static InstanceHardwareJsonMarshaller instance;

    public void marshall(InstanceHardware instanceHardware, StructuredJsonGenerator jsonGenerator) {
        if (instanceHardware == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Disk> disksList;
            jsonGenerator.writeStartObject();
            if (instanceHardware.getCpuCount() != null) {
                jsonGenerator.writeFieldName("cpuCount").writeValue(instanceHardware.getCpuCount().intValue());
            }
            if ((disksList = instanceHardware.getDisks()) != null) {
                jsonGenerator.writeFieldName("disks");
                jsonGenerator.writeStartArray();
                for (Disk disksListValue : disksList) {
                    if (disksListValue == null) continue;
                    DiskJsonMarshaller.getInstance().marshall(disksListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (instanceHardware.getRamSizeInGb() != null) {
                jsonGenerator.writeFieldName("ramSizeInGb").writeValue(instanceHardware.getRamSizeInGb().floatValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceHardwareJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceHardwareJsonMarshaller();
        }
        return instance;
    }
}

