/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.CacheBehavior;
import com.amazonaws.services.lightsail.model.CacheBehaviorPerPath;
import com.amazonaws.services.lightsail.model.CacheSettings;
import com.amazonaws.services.lightsail.model.IpAddressType;
import com.amazonaws.services.lightsail.model.Origin;
import com.amazonaws.services.lightsail.model.ResourceLocation;
import com.amazonaws.services.lightsail.model.ResourceType;
import com.amazonaws.services.lightsail.model.Tag;
import com.amazonaws.services.lightsail.model.transform.LightsailDistributionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class LightsailDistribution
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String arn;
    private String supportCode;
    private Date createdAt;
    private ResourceLocation location;
    private String resourceType;
    private List<String> alternativeDomainNames;
    private String status;
    private Boolean isEnabled;
    private String domainName;
    private String bundleId;
    private String certificateName;
    private Origin origin;
    private String originPublicDNS;
    private CacheBehavior defaultCacheBehavior;
    private CacheSettings cacheBehaviorSettings;
    private List<CacheBehaviorPerPath> cacheBehaviors;
    private Boolean ableToUpdateBundle;
    private String ipAddressType;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LightsailDistribution withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public LightsailDistribution withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setSupportCode(String supportCode) {
        this.supportCode = supportCode;
    }

    public String getSupportCode() {
        return this.supportCode;
    }

    public LightsailDistribution withSupportCode(String supportCode) {
        this.setSupportCode(supportCode);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public LightsailDistribution withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public LightsailDistribution withLocation(ResourceLocation location) {
        this.setLocation(location);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public LightsailDistribution withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public LightsailDistribution withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<String> getAlternativeDomainNames() {
        return this.alternativeDomainNames;
    }

    public void setAlternativeDomainNames(Collection<String> alternativeDomainNames) {
        if (alternativeDomainNames == null) {
            this.alternativeDomainNames = null;
            return;
        }
        this.alternativeDomainNames = new ArrayList<String>(alternativeDomainNames);
    }

    public LightsailDistribution withAlternativeDomainNames(String ... alternativeDomainNames) {
        if (this.alternativeDomainNames == null) {
            this.setAlternativeDomainNames(new ArrayList<String>(alternativeDomainNames.length));
        }
        for (String ele : alternativeDomainNames) {
            this.alternativeDomainNames.add(ele);
        }
        return this;
    }

    public LightsailDistribution withAlternativeDomainNames(Collection<String> alternativeDomainNames) {
        this.setAlternativeDomainNames(alternativeDomainNames);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public LightsailDistribution withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public LightsailDistribution withIsEnabled(Boolean isEnabled) {
        this.setIsEnabled(isEnabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public LightsailDistribution withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public LightsailDistribution withBundleId(String bundleId) {
        this.setBundleId(bundleId);
        return this;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public LightsailDistribution withCertificateName(String certificateName) {
        this.setCertificateName(certificateName);
        return this;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public LightsailDistribution withOrigin(Origin origin) {
        this.setOrigin(origin);
        return this;
    }

    public void setOriginPublicDNS(String originPublicDNS) {
        this.originPublicDNS = originPublicDNS;
    }

    public String getOriginPublicDNS() {
        return this.originPublicDNS;
    }

    public LightsailDistribution withOriginPublicDNS(String originPublicDNS) {
        this.setOriginPublicDNS(originPublicDNS);
        return this;
    }

    public void setDefaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
        this.defaultCacheBehavior = defaultCacheBehavior;
    }

    public CacheBehavior getDefaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public LightsailDistribution withDefaultCacheBehavior(CacheBehavior defaultCacheBehavior) {
        this.setDefaultCacheBehavior(defaultCacheBehavior);
        return this;
    }

    public void setCacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
        this.cacheBehaviorSettings = cacheBehaviorSettings;
    }

    public CacheSettings getCacheBehaviorSettings() {
        return this.cacheBehaviorSettings;
    }

    public LightsailDistribution withCacheBehaviorSettings(CacheSettings cacheBehaviorSettings) {
        this.setCacheBehaviorSettings(cacheBehaviorSettings);
        return this;
    }

    public List<CacheBehaviorPerPath> getCacheBehaviors() {
        return this.cacheBehaviors;
    }

    public void setCacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
        if (cacheBehaviors == null) {
            this.cacheBehaviors = null;
            return;
        }
        this.cacheBehaviors = new ArrayList<CacheBehaviorPerPath>(cacheBehaviors);
    }

    public LightsailDistribution withCacheBehaviors(CacheBehaviorPerPath ... cacheBehaviors) {
        if (this.cacheBehaviors == null) {
            this.setCacheBehaviors(new ArrayList<CacheBehaviorPerPath>(cacheBehaviors.length));
        }
        for (CacheBehaviorPerPath ele : cacheBehaviors) {
            this.cacheBehaviors.add(ele);
        }
        return this;
    }

    public LightsailDistribution withCacheBehaviors(Collection<CacheBehaviorPerPath> cacheBehaviors) {
        this.setCacheBehaviors(cacheBehaviors);
        return this;
    }

    public void setAbleToUpdateBundle(Boolean ableToUpdateBundle) {
        this.ableToUpdateBundle = ableToUpdateBundle;
    }

    public Boolean getAbleToUpdateBundle() {
        return this.ableToUpdateBundle;
    }

    public LightsailDistribution withAbleToUpdateBundle(Boolean ableToUpdateBundle) {
        this.setAbleToUpdateBundle(ableToUpdateBundle);
        return this;
    }

    public Boolean isAbleToUpdateBundle() {
        return this.ableToUpdateBundle;
    }

    public void setIpAddressType(String ipAddressType) {
        this.ipAddressType = ipAddressType;
    }

    public String getIpAddressType() {
        return this.ipAddressType;
    }

    public LightsailDistribution withIpAddressType(String ipAddressType) {
        this.setIpAddressType(ipAddressType);
        return this;
    }

    public LightsailDistribution withIpAddressType(IpAddressType ipAddressType) {
        this.ipAddressType = ipAddressType.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public LightsailDistribution withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public LightsailDistribution withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getSupportCode() != null) {
            sb.append("SupportCode: ").append(this.getSupportCode()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getAlternativeDomainNames() != null) {
            sb.append("AlternativeDomainNames: ").append(this.getAlternativeDomainNames()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getIsEnabled() != null) {
            sb.append("IsEnabled: ").append(this.getIsEnabled()).append(",");
        }
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getBundleId() != null) {
            sb.append("BundleId: ").append(this.getBundleId()).append(",");
        }
        if (this.getCertificateName() != null) {
            sb.append("CertificateName: ").append(this.getCertificateName()).append(",");
        }
        if (this.getOrigin() != null) {
            sb.append("Origin: ").append(this.getOrigin()).append(",");
        }
        if (this.getOriginPublicDNS() != null) {
            sb.append("OriginPublicDNS: ").append(this.getOriginPublicDNS()).append(",");
        }
        if (this.getDefaultCacheBehavior() != null) {
            sb.append("DefaultCacheBehavior: ").append(this.getDefaultCacheBehavior()).append(",");
        }
        if (this.getCacheBehaviorSettings() != null) {
            sb.append("CacheBehaviorSettings: ").append(this.getCacheBehaviorSettings()).append(",");
        }
        if (this.getCacheBehaviors() != null) {
            sb.append("CacheBehaviors: ").append(this.getCacheBehaviors()).append(",");
        }
        if (this.getAbleToUpdateBundle() != null) {
            sb.append("AbleToUpdateBundle: ").append(this.getAbleToUpdateBundle()).append(",");
        }
        if (this.getIpAddressType() != null) {
            sb.append("IpAddressType: ").append(this.getIpAddressType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LightsailDistribution)) {
            return false;
        }
        LightsailDistribution other = (LightsailDistribution)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getSupportCode() == null ^ this.getSupportCode() == null) {
            return false;
        }
        if (other.getSupportCode() != null && !other.getSupportCode().equals(this.getSupportCode())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getAlternativeDomainNames() == null ^ this.getAlternativeDomainNames() == null) {
            return false;
        }
        if (other.getAlternativeDomainNames() != null && !other.getAlternativeDomainNames().equals(this.getAlternativeDomainNames())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getIsEnabled() == null ^ this.getIsEnabled() == null) {
            return false;
        }
        if (other.getIsEnabled() != null && !other.getIsEnabled().equals(this.getIsEnabled())) {
            return false;
        }
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getBundleId() == null ^ this.getBundleId() == null) {
            return false;
        }
        if (other.getBundleId() != null && !other.getBundleId().equals(this.getBundleId())) {
            return false;
        }
        if (other.getCertificateName() == null ^ this.getCertificateName() == null) {
            return false;
        }
        if (other.getCertificateName() != null && !other.getCertificateName().equals(this.getCertificateName())) {
            return false;
        }
        if (other.getOrigin() == null ^ this.getOrigin() == null) {
            return false;
        }
        if (other.getOrigin() != null && !other.getOrigin().equals(this.getOrigin())) {
            return false;
        }
        if (other.getOriginPublicDNS() == null ^ this.getOriginPublicDNS() == null) {
            return false;
        }
        if (other.getOriginPublicDNS() != null && !other.getOriginPublicDNS().equals(this.getOriginPublicDNS())) {
            return false;
        }
        if (other.getDefaultCacheBehavior() == null ^ this.getDefaultCacheBehavior() == null) {
            return false;
        }
        if (other.getDefaultCacheBehavior() != null && !other.getDefaultCacheBehavior().equals(this.getDefaultCacheBehavior())) {
            return false;
        }
        if (other.getCacheBehaviorSettings() == null ^ this.getCacheBehaviorSettings() == null) {
            return false;
        }
        if (other.getCacheBehaviorSettings() != null && !other.getCacheBehaviorSettings().equals(this.getCacheBehaviorSettings())) {
            return false;
        }
        if (other.getCacheBehaviors() == null ^ this.getCacheBehaviors() == null) {
            return false;
        }
        if (other.getCacheBehaviors() != null && !other.getCacheBehaviors().equals(this.getCacheBehaviors())) {
            return false;
        }
        if (other.getAbleToUpdateBundle() == null ^ this.getAbleToUpdateBundle() == null) {
            return false;
        }
        if (other.getAbleToUpdateBundle() != null && !other.getAbleToUpdateBundle().equals(this.getAbleToUpdateBundle())) {
            return false;
        }
        if (other.getIpAddressType() == null ^ this.getIpAddressType() == null) {
            return false;
        }
        if (other.getIpAddressType() != null && !other.getIpAddressType().equals(this.getIpAddressType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getSupportCode() == null ? 0 : this.getSupportCode().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getAlternativeDomainNames() == null ? 0 : this.getAlternativeDomainNames().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getIsEnabled() == null ? 0 : this.getIsEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getBundleId() == null ? 0 : this.getBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateName() == null ? 0 : this.getCertificateName().hashCode());
        hashCode = 31 * hashCode + (this.getOrigin() == null ? 0 : this.getOrigin().hashCode());
        hashCode = 31 * hashCode + (this.getOriginPublicDNS() == null ? 0 : this.getOriginPublicDNS().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultCacheBehavior() == null ? 0 : this.getDefaultCacheBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getCacheBehaviorSettings() == null ? 0 : this.getCacheBehaviorSettings().hashCode());
        hashCode = 31 * hashCode + (this.getCacheBehaviors() == null ? 0 : this.getCacheBehaviors().hashCode());
        hashCode = 31 * hashCode + (this.getAbleToUpdateBundle() == null ? 0 : this.getAbleToUpdateBundle().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddressType() == null ? 0 : this.getIpAddressType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public LightsailDistribution clone() {
        try {
            return (LightsailDistribution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LightsailDistributionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

