/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.licensemanager.model.Issuer;

@SdkInternalApi
public class IssuerMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> SIGNKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SignKey").build();
    private static final IssuerMarshaller instance = new IssuerMarshaller();

    public static IssuerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Issuer issuer, ProtocolMarshaller protocolMarshaller) {
        if (issuer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)issuer.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)issuer.getSignKey(), SIGNKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

