/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.licensemanager.model.AutomatedDiscoveryInformation;
import com.amazonaws.services.licensemanager.model.ConsumedLicenseSummary;
import com.amazonaws.services.licensemanager.model.LicenseCountingType;
import com.amazonaws.services.licensemanager.model.ManagedResourceSummary;
import com.amazonaws.services.licensemanager.model.ProductInformation;
import com.amazonaws.services.licensemanager.model.transform.LicenseConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LicenseConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String licenseConfigurationId;
    private String licenseConfigurationArn;
    private String name;
    private String description;
    private String licenseCountingType;
    private List<String> licenseRules;
    private Long licenseCount;
    private Boolean licenseCountHardLimit;
    private Boolean disassociateWhenNotFound;
    private Long consumedLicenses;
    private String status;
    private String ownerAccountId;
    private List<ConsumedLicenseSummary> consumedLicenseSummaryList;
    private List<ManagedResourceSummary> managedResourceSummaryList;
    private List<ProductInformation> productInformationList;
    private AutomatedDiscoveryInformation automatedDiscoveryInformation;

    public void setLicenseConfigurationId(String licenseConfigurationId) {
        this.licenseConfigurationId = licenseConfigurationId;
    }

    public String getLicenseConfigurationId() {
        return this.licenseConfigurationId;
    }

    public LicenseConfiguration withLicenseConfigurationId(String licenseConfigurationId) {
        this.setLicenseConfigurationId(licenseConfigurationId);
        return this;
    }

    public void setLicenseConfigurationArn(String licenseConfigurationArn) {
        this.licenseConfigurationArn = licenseConfigurationArn;
    }

    public String getLicenseConfigurationArn() {
        return this.licenseConfigurationArn;
    }

    public LicenseConfiguration withLicenseConfigurationArn(String licenseConfigurationArn) {
        this.setLicenseConfigurationArn(licenseConfigurationArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LicenseConfiguration withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public LicenseConfiguration withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setLicenseCountingType(String licenseCountingType) {
        this.licenseCountingType = licenseCountingType;
    }

    public String getLicenseCountingType() {
        return this.licenseCountingType;
    }

    public LicenseConfiguration withLicenseCountingType(String licenseCountingType) {
        this.setLicenseCountingType(licenseCountingType);
        return this;
    }

    public LicenseConfiguration withLicenseCountingType(LicenseCountingType licenseCountingType) {
        this.licenseCountingType = licenseCountingType.toString();
        return this;
    }

    public List<String> getLicenseRules() {
        return this.licenseRules;
    }

    public void setLicenseRules(Collection<String> licenseRules) {
        if (licenseRules == null) {
            this.licenseRules = null;
            return;
        }
        this.licenseRules = new ArrayList<String>(licenseRules);
    }

    public LicenseConfiguration withLicenseRules(String ... licenseRules) {
        if (this.licenseRules == null) {
            this.setLicenseRules(new ArrayList<String>(licenseRules.length));
        }
        for (String ele : licenseRules) {
            this.licenseRules.add(ele);
        }
        return this;
    }

    public LicenseConfiguration withLicenseRules(Collection<String> licenseRules) {
        this.setLicenseRules(licenseRules);
        return this;
    }

    public void setLicenseCount(Long licenseCount) {
        this.licenseCount = licenseCount;
    }

    public Long getLicenseCount() {
        return this.licenseCount;
    }

    public LicenseConfiguration withLicenseCount(Long licenseCount) {
        this.setLicenseCount(licenseCount);
        return this;
    }

    public void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
        this.licenseCountHardLimit = licenseCountHardLimit;
    }

    public Boolean getLicenseCountHardLimit() {
        return this.licenseCountHardLimit;
    }

    public LicenseConfiguration withLicenseCountHardLimit(Boolean licenseCountHardLimit) {
        this.setLicenseCountHardLimit(licenseCountHardLimit);
        return this;
    }

    public Boolean isLicenseCountHardLimit() {
        return this.licenseCountHardLimit;
    }

    public void setDisassociateWhenNotFound(Boolean disassociateWhenNotFound) {
        this.disassociateWhenNotFound = disassociateWhenNotFound;
    }

    public Boolean getDisassociateWhenNotFound() {
        return this.disassociateWhenNotFound;
    }

    public LicenseConfiguration withDisassociateWhenNotFound(Boolean disassociateWhenNotFound) {
        this.setDisassociateWhenNotFound(disassociateWhenNotFound);
        return this;
    }

    public Boolean isDisassociateWhenNotFound() {
        return this.disassociateWhenNotFound;
    }

    public void setConsumedLicenses(Long consumedLicenses) {
        this.consumedLicenses = consumedLicenses;
    }

    public Long getConsumedLicenses() {
        return this.consumedLicenses;
    }

    public LicenseConfiguration withConsumedLicenses(Long consumedLicenses) {
        this.setConsumedLicenses(consumedLicenses);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public LicenseConfiguration withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setOwnerAccountId(String ownerAccountId) {
        this.ownerAccountId = ownerAccountId;
    }

    public String getOwnerAccountId() {
        return this.ownerAccountId;
    }

    public LicenseConfiguration withOwnerAccountId(String ownerAccountId) {
        this.setOwnerAccountId(ownerAccountId);
        return this;
    }

    public List<ConsumedLicenseSummary> getConsumedLicenseSummaryList() {
        return this.consumedLicenseSummaryList;
    }

    public void setConsumedLicenseSummaryList(Collection<ConsumedLicenseSummary> consumedLicenseSummaryList) {
        if (consumedLicenseSummaryList == null) {
            this.consumedLicenseSummaryList = null;
            return;
        }
        this.consumedLicenseSummaryList = new ArrayList<ConsumedLicenseSummary>(consumedLicenseSummaryList);
    }

    public LicenseConfiguration withConsumedLicenseSummaryList(ConsumedLicenseSummary ... consumedLicenseSummaryList) {
        if (this.consumedLicenseSummaryList == null) {
            this.setConsumedLicenseSummaryList(new ArrayList<ConsumedLicenseSummary>(consumedLicenseSummaryList.length));
        }
        for (ConsumedLicenseSummary ele : consumedLicenseSummaryList) {
            this.consumedLicenseSummaryList.add(ele);
        }
        return this;
    }

    public LicenseConfiguration withConsumedLicenseSummaryList(Collection<ConsumedLicenseSummary> consumedLicenseSummaryList) {
        this.setConsumedLicenseSummaryList(consumedLicenseSummaryList);
        return this;
    }

    public List<ManagedResourceSummary> getManagedResourceSummaryList() {
        return this.managedResourceSummaryList;
    }

    public void setManagedResourceSummaryList(Collection<ManagedResourceSummary> managedResourceSummaryList) {
        if (managedResourceSummaryList == null) {
            this.managedResourceSummaryList = null;
            return;
        }
        this.managedResourceSummaryList = new ArrayList<ManagedResourceSummary>(managedResourceSummaryList);
    }

    public LicenseConfiguration withManagedResourceSummaryList(ManagedResourceSummary ... managedResourceSummaryList) {
        if (this.managedResourceSummaryList == null) {
            this.setManagedResourceSummaryList(new ArrayList<ManagedResourceSummary>(managedResourceSummaryList.length));
        }
        for (ManagedResourceSummary ele : managedResourceSummaryList) {
            this.managedResourceSummaryList.add(ele);
        }
        return this;
    }

    public LicenseConfiguration withManagedResourceSummaryList(Collection<ManagedResourceSummary> managedResourceSummaryList) {
        this.setManagedResourceSummaryList(managedResourceSummaryList);
        return this;
    }

    public List<ProductInformation> getProductInformationList() {
        return this.productInformationList;
    }

    public void setProductInformationList(Collection<ProductInformation> productInformationList) {
        if (productInformationList == null) {
            this.productInformationList = null;
            return;
        }
        this.productInformationList = new ArrayList<ProductInformation>(productInformationList);
    }

    public LicenseConfiguration withProductInformationList(ProductInformation ... productInformationList) {
        if (this.productInformationList == null) {
            this.setProductInformationList(new ArrayList<ProductInformation>(productInformationList.length));
        }
        for (ProductInformation ele : productInformationList) {
            this.productInformationList.add(ele);
        }
        return this;
    }

    public LicenseConfiguration withProductInformationList(Collection<ProductInformation> productInformationList) {
        this.setProductInformationList(productInformationList);
        return this;
    }

    public void setAutomatedDiscoveryInformation(AutomatedDiscoveryInformation automatedDiscoveryInformation) {
        this.automatedDiscoveryInformation = automatedDiscoveryInformation;
    }

    public AutomatedDiscoveryInformation getAutomatedDiscoveryInformation() {
        return this.automatedDiscoveryInformation;
    }

    public LicenseConfiguration withAutomatedDiscoveryInformation(AutomatedDiscoveryInformation automatedDiscoveryInformation) {
        this.setAutomatedDiscoveryInformation(automatedDiscoveryInformation);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLicenseConfigurationId() != null) {
            sb.append("LicenseConfigurationId: ").append(this.getLicenseConfigurationId()).append(",");
        }
        if (this.getLicenseConfigurationArn() != null) {
            sb.append("LicenseConfigurationArn: ").append(this.getLicenseConfigurationArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getLicenseCountingType() != null) {
            sb.append("LicenseCountingType: ").append(this.getLicenseCountingType()).append(",");
        }
        if (this.getLicenseRules() != null) {
            sb.append("LicenseRules: ").append(this.getLicenseRules()).append(",");
        }
        if (this.getLicenseCount() != null) {
            sb.append("LicenseCount: ").append(this.getLicenseCount()).append(",");
        }
        if (this.getLicenseCountHardLimit() != null) {
            sb.append("LicenseCountHardLimit: ").append(this.getLicenseCountHardLimit()).append(",");
        }
        if (this.getDisassociateWhenNotFound() != null) {
            sb.append("DisassociateWhenNotFound: ").append(this.getDisassociateWhenNotFound()).append(",");
        }
        if (this.getConsumedLicenses() != null) {
            sb.append("ConsumedLicenses: ").append(this.getConsumedLicenses()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getOwnerAccountId() != null) {
            sb.append("OwnerAccountId: ").append(this.getOwnerAccountId()).append(",");
        }
        if (this.getConsumedLicenseSummaryList() != null) {
            sb.append("ConsumedLicenseSummaryList: ").append(this.getConsumedLicenseSummaryList()).append(",");
        }
        if (this.getManagedResourceSummaryList() != null) {
            sb.append("ManagedResourceSummaryList: ").append(this.getManagedResourceSummaryList()).append(",");
        }
        if (this.getProductInformationList() != null) {
            sb.append("ProductInformationList: ").append(this.getProductInformationList()).append(",");
        }
        if (this.getAutomatedDiscoveryInformation() != null) {
            sb.append("AutomatedDiscoveryInformation: ").append(this.getAutomatedDiscoveryInformation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConfiguration)) {
            return false;
        }
        LicenseConfiguration other = (LicenseConfiguration)obj;
        if (other.getLicenseConfigurationId() == null ^ this.getLicenseConfigurationId() == null) {
            return false;
        }
        if (other.getLicenseConfigurationId() != null && !other.getLicenseConfigurationId().equals(this.getLicenseConfigurationId())) {
            return false;
        }
        if (other.getLicenseConfigurationArn() == null ^ this.getLicenseConfigurationArn() == null) {
            return false;
        }
        if (other.getLicenseConfigurationArn() != null && !other.getLicenseConfigurationArn().equals(this.getLicenseConfigurationArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getLicenseCountingType() == null ^ this.getLicenseCountingType() == null) {
            return false;
        }
        if (other.getLicenseCountingType() != null && !other.getLicenseCountingType().equals(this.getLicenseCountingType())) {
            return false;
        }
        if (other.getLicenseRules() == null ^ this.getLicenseRules() == null) {
            return false;
        }
        if (other.getLicenseRules() != null && !other.getLicenseRules().equals(this.getLicenseRules())) {
            return false;
        }
        if (other.getLicenseCount() == null ^ this.getLicenseCount() == null) {
            return false;
        }
        if (other.getLicenseCount() != null && !other.getLicenseCount().equals(this.getLicenseCount())) {
            return false;
        }
        if (other.getLicenseCountHardLimit() == null ^ this.getLicenseCountHardLimit() == null) {
            return false;
        }
        if (other.getLicenseCountHardLimit() != null && !other.getLicenseCountHardLimit().equals(this.getLicenseCountHardLimit())) {
            return false;
        }
        if (other.getDisassociateWhenNotFound() == null ^ this.getDisassociateWhenNotFound() == null) {
            return false;
        }
        if (other.getDisassociateWhenNotFound() != null && !other.getDisassociateWhenNotFound().equals(this.getDisassociateWhenNotFound())) {
            return false;
        }
        if (other.getConsumedLicenses() == null ^ this.getConsumedLicenses() == null) {
            return false;
        }
        if (other.getConsumedLicenses() != null && !other.getConsumedLicenses().equals(this.getConsumedLicenses())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getOwnerAccountId() == null ^ this.getOwnerAccountId() == null) {
            return false;
        }
        if (other.getOwnerAccountId() != null && !other.getOwnerAccountId().equals(this.getOwnerAccountId())) {
            return false;
        }
        if (other.getConsumedLicenseSummaryList() == null ^ this.getConsumedLicenseSummaryList() == null) {
            return false;
        }
        if (other.getConsumedLicenseSummaryList() != null && !other.getConsumedLicenseSummaryList().equals(this.getConsumedLicenseSummaryList())) {
            return false;
        }
        if (other.getManagedResourceSummaryList() == null ^ this.getManagedResourceSummaryList() == null) {
            return false;
        }
        if (other.getManagedResourceSummaryList() != null && !other.getManagedResourceSummaryList().equals(this.getManagedResourceSummaryList())) {
            return false;
        }
        if (other.getProductInformationList() == null ^ this.getProductInformationList() == null) {
            return false;
        }
        if (other.getProductInformationList() != null && !other.getProductInformationList().equals(this.getProductInformationList())) {
            return false;
        }
        if (other.getAutomatedDiscoveryInformation() == null ^ this.getAutomatedDiscoveryInformation() == null) {
            return false;
        }
        return other.getAutomatedDiscoveryInformation() == null || other.getAutomatedDiscoveryInformation().equals(this.getAutomatedDiscoveryInformation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLicenseConfigurationId() == null ? 0 : this.getLicenseConfigurationId().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseConfigurationArn() == null ? 0 : this.getLicenseConfigurationArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseCountingType() == null ? 0 : this.getLicenseCountingType().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseRules() == null ? 0 : this.getLicenseRules().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseCount() == null ? 0 : this.getLicenseCount().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseCountHardLimit() == null ? 0 : this.getLicenseCountHardLimit().hashCode());
        hashCode = 31 * hashCode + (this.getDisassociateWhenNotFound() == null ? 0 : this.getDisassociateWhenNotFound().hashCode());
        hashCode = 31 * hashCode + (this.getConsumedLicenses() == null ? 0 : this.getConsumedLicenses().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerAccountId() == null ? 0 : this.getOwnerAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getConsumedLicenseSummaryList() == null ? 0 : this.getConsumedLicenseSummaryList().hashCode());
        hashCode = 31 * hashCode + (this.getManagedResourceSummaryList() == null ? 0 : this.getManagedResourceSummaryList().hashCode());
        hashCode = 31 * hashCode + (this.getProductInformationList() == null ? 0 : this.getProductInformationList().hashCode());
        hashCode = 31 * hashCode + (this.getAutomatedDiscoveryInformation() == null ? 0 : this.getAutomatedDiscoveryInformation().hashCode());
        return hashCode;
    }

    public LicenseConfiguration clone() {
        try {
            return (LicenseConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LicenseConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

