/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.licensemanager.model.License;
import java.util.List;

@SdkInternalApi
public class LicenseMarshaller {
    private static final MarshallingInfo<String> LICENSEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LicenseArn").build();
    private static final MarshallingInfo<String> LICENSENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LicenseName").build();
    private static final MarshallingInfo<String> PRODUCTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductName").build();
    private static final MarshallingInfo<String> PRODUCTSKU_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductSKU").build();
    private static final MarshallingInfo<StructuredPojo> ISSUER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Issuer").build();
    private static final MarshallingInfo<String> HOMEREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HomeRegion").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> VALIDITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Validity").build();
    private static final MarshallingInfo<String> BENEFICIARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Beneficiary").build();
    private static final MarshallingInfo<List> ENTITLEMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Entitlements").build();
    private static final MarshallingInfo<StructuredPojo> CONSUMPTIONCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConsumptionConfiguration").build();
    private static final MarshallingInfo<List> LICENSEMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LicenseMetadata").build();
    private static final MarshallingInfo<String> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTime").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final LicenseMarshaller instance = new LicenseMarshaller();

    public static LicenseMarshaller getInstance() {
        return instance;
    }

    public void marshall(License license, ProtocolMarshaller protocolMarshaller) {
        if (license == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)license.getLicenseArn(), LICENSEARN_BINDING);
            protocolMarshaller.marshall((Object)license.getLicenseName(), LICENSENAME_BINDING);
            protocolMarshaller.marshall((Object)license.getProductName(), PRODUCTNAME_BINDING);
            protocolMarshaller.marshall((Object)license.getProductSKU(), PRODUCTSKU_BINDING);
            protocolMarshaller.marshall((Object)license.getIssuer(), ISSUER_BINDING);
            protocolMarshaller.marshall((Object)license.getHomeRegion(), HOMEREGION_BINDING);
            protocolMarshaller.marshall((Object)license.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)license.getValidity(), VALIDITY_BINDING);
            protocolMarshaller.marshall((Object)license.getBeneficiary(), BENEFICIARY_BINDING);
            protocolMarshaller.marshall(license.getEntitlements(), ENTITLEMENTS_BINDING);
            protocolMarshaller.marshall((Object)license.getConsumptionConfiguration(), CONSUMPTIONCONFIGURATION_BINDING);
            protocolMarshaller.marshall(license.getLicenseMetadata(), LICENSEMETADATA_BINDING);
            protocolMarshaller.marshall((Object)license.getCreateTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall((Object)license.getVersion(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

