/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.licensemanager.model.AllowedOperation;
import com.amazonaws.services.licensemanager.model.GrantStatus;
import com.amazonaws.services.licensemanager.model.transform.GrantMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Grant
implements Serializable,
Cloneable,
StructuredPojo {
    private String grantArn;
    private String grantName;
    private String parentArn;
    private String licenseArn;
    private String granteePrincipalArn;
    private String homeRegion;
    private String grantStatus;
    private String statusReason;
    private String version;
    private List<String> grantedOperations;

    public void setGrantArn(String grantArn) {
        this.grantArn = grantArn;
    }

    public String getGrantArn() {
        return this.grantArn;
    }

    public Grant withGrantArn(String grantArn) {
        this.setGrantArn(grantArn);
        return this;
    }

    public void setGrantName(String grantName) {
        this.grantName = grantName;
    }

    public String getGrantName() {
        return this.grantName;
    }

    public Grant withGrantName(String grantName) {
        this.setGrantName(grantName);
        return this;
    }

    public void setParentArn(String parentArn) {
        this.parentArn = parentArn;
    }

    public String getParentArn() {
        return this.parentArn;
    }

    public Grant withParentArn(String parentArn) {
        this.setParentArn(parentArn);
        return this;
    }

    public void setLicenseArn(String licenseArn) {
        this.licenseArn = licenseArn;
    }

    public String getLicenseArn() {
        return this.licenseArn;
    }

    public Grant withLicenseArn(String licenseArn) {
        this.setLicenseArn(licenseArn);
        return this;
    }

    public void setGranteePrincipalArn(String granteePrincipalArn) {
        this.granteePrincipalArn = granteePrincipalArn;
    }

    public String getGranteePrincipalArn() {
        return this.granteePrincipalArn;
    }

    public Grant withGranteePrincipalArn(String granteePrincipalArn) {
        this.setGranteePrincipalArn(granteePrincipalArn);
        return this;
    }

    public void setHomeRegion(String homeRegion) {
        this.homeRegion = homeRegion;
    }

    public String getHomeRegion() {
        return this.homeRegion;
    }

    public Grant withHomeRegion(String homeRegion) {
        this.setHomeRegion(homeRegion);
        return this;
    }

    public void setGrantStatus(String grantStatus) {
        this.grantStatus = grantStatus;
    }

    public String getGrantStatus() {
        return this.grantStatus;
    }

    public Grant withGrantStatus(String grantStatus) {
        this.setGrantStatus(grantStatus);
        return this;
    }

    public Grant withGrantStatus(GrantStatus grantStatus) {
        this.grantStatus = grantStatus.toString();
        return this;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public Grant withStatusReason(String statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Grant withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public List<String> getGrantedOperations() {
        return this.grantedOperations;
    }

    public void setGrantedOperations(Collection<String> grantedOperations) {
        if (grantedOperations == null) {
            this.grantedOperations = null;
            return;
        }
        this.grantedOperations = new ArrayList<String>(grantedOperations);
    }

    public Grant withGrantedOperations(String ... grantedOperations) {
        if (this.grantedOperations == null) {
            this.setGrantedOperations(new ArrayList<String>(grantedOperations.length));
        }
        for (String ele : grantedOperations) {
            this.grantedOperations.add(ele);
        }
        return this;
    }

    public Grant withGrantedOperations(Collection<String> grantedOperations) {
        this.setGrantedOperations(grantedOperations);
        return this;
    }

    public Grant withGrantedOperations(AllowedOperation ... grantedOperations) {
        ArrayList<String> grantedOperationsCopy = new ArrayList<String>(grantedOperations.length);
        for (AllowedOperation value : grantedOperations) {
            grantedOperationsCopy.add(value.toString());
        }
        if (this.getGrantedOperations() == null) {
            this.setGrantedOperations(grantedOperationsCopy);
        } else {
            this.getGrantedOperations().addAll(grantedOperationsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGrantArn() != null) {
            sb.append("GrantArn: ").append(this.getGrantArn()).append(",");
        }
        if (this.getGrantName() != null) {
            sb.append("GrantName: ").append(this.getGrantName()).append(",");
        }
        if (this.getParentArn() != null) {
            sb.append("ParentArn: ").append(this.getParentArn()).append(",");
        }
        if (this.getLicenseArn() != null) {
            sb.append("LicenseArn: ").append(this.getLicenseArn()).append(",");
        }
        if (this.getGranteePrincipalArn() != null) {
            sb.append("GranteePrincipalArn: ").append(this.getGranteePrincipalArn()).append(",");
        }
        if (this.getHomeRegion() != null) {
            sb.append("HomeRegion: ").append(this.getHomeRegion()).append(",");
        }
        if (this.getGrantStatus() != null) {
            sb.append("GrantStatus: ").append(this.getGrantStatus()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getGrantedOperations() != null) {
            sb.append("GrantedOperations: ").append(this.getGrantedOperations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grant)) {
            return false;
        }
        Grant other = (Grant)obj;
        if (other.getGrantArn() == null ^ this.getGrantArn() == null) {
            return false;
        }
        if (other.getGrantArn() != null && !other.getGrantArn().equals(this.getGrantArn())) {
            return false;
        }
        if (other.getGrantName() == null ^ this.getGrantName() == null) {
            return false;
        }
        if (other.getGrantName() != null && !other.getGrantName().equals(this.getGrantName())) {
            return false;
        }
        if (other.getParentArn() == null ^ this.getParentArn() == null) {
            return false;
        }
        if (other.getParentArn() != null && !other.getParentArn().equals(this.getParentArn())) {
            return false;
        }
        if (other.getLicenseArn() == null ^ this.getLicenseArn() == null) {
            return false;
        }
        if (other.getLicenseArn() != null && !other.getLicenseArn().equals(this.getLicenseArn())) {
            return false;
        }
        if (other.getGranteePrincipalArn() == null ^ this.getGranteePrincipalArn() == null) {
            return false;
        }
        if (other.getGranteePrincipalArn() != null && !other.getGranteePrincipalArn().equals(this.getGranteePrincipalArn())) {
            return false;
        }
        if (other.getHomeRegion() == null ^ this.getHomeRegion() == null) {
            return false;
        }
        if (other.getHomeRegion() != null && !other.getHomeRegion().equals(this.getHomeRegion())) {
            return false;
        }
        if (other.getGrantStatus() == null ^ this.getGrantStatus() == null) {
            return false;
        }
        if (other.getGrantStatus() != null && !other.getGrantStatus().equals(this.getGrantStatus())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        if (other.getStatusReason() != null && !other.getStatusReason().equals(this.getStatusReason())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getGrantedOperations() == null ^ this.getGrantedOperations() == null) {
            return false;
        }
        return other.getGrantedOperations() == null || other.getGrantedOperations().equals(this.getGrantedOperations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGrantArn() == null ? 0 : this.getGrantArn().hashCode());
        hashCode = 31 * hashCode + (this.getGrantName() == null ? 0 : this.getGrantName().hashCode());
        hashCode = 31 * hashCode + (this.getParentArn() == null ? 0 : this.getParentArn().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseArn() == null ? 0 : this.getLicenseArn().hashCode());
        hashCode = 31 * hashCode + (this.getGranteePrincipalArn() == null ? 0 : this.getGranteePrincipalArn().hashCode());
        hashCode = 31 * hashCode + (this.getHomeRegion() == null ? 0 : this.getHomeRegion().hashCode());
        hashCode = 31 * hashCode + (this.getGrantStatus() == null ? 0 : this.getGrantStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getGrantedOperations() == null ? 0 : this.getGrantedOperations().hashCode());
        return hashCode;
    }

    public Grant clone() {
        try {
            return (Grant)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GrantMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

