/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.licensemanager.model.LicenseConfigurationStatus;
import com.amazonaws.services.licensemanager.model.ProductInformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateLicenseConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String licenseConfigurationArn;
    private String licenseConfigurationStatus;
    private List<String> licenseRules;
    private Long licenseCount;
    private Boolean licenseCountHardLimit;
    private String name;
    private String description;
    private List<ProductInformation> productInformationList;
    private Boolean disassociateWhenNotFound;

    public void setLicenseConfigurationArn(String licenseConfigurationArn) {
        this.licenseConfigurationArn = licenseConfigurationArn;
    }

    public String getLicenseConfigurationArn() {
        return this.licenseConfigurationArn;
    }

    public UpdateLicenseConfigurationRequest withLicenseConfigurationArn(String licenseConfigurationArn) {
        this.setLicenseConfigurationArn(licenseConfigurationArn);
        return this;
    }

    public void setLicenseConfigurationStatus(String licenseConfigurationStatus) {
        this.licenseConfigurationStatus = licenseConfigurationStatus;
    }

    public String getLicenseConfigurationStatus() {
        return this.licenseConfigurationStatus;
    }

    public UpdateLicenseConfigurationRequest withLicenseConfigurationStatus(String licenseConfigurationStatus) {
        this.setLicenseConfigurationStatus(licenseConfigurationStatus);
        return this;
    }

    public UpdateLicenseConfigurationRequest withLicenseConfigurationStatus(LicenseConfigurationStatus licenseConfigurationStatus) {
        this.licenseConfigurationStatus = licenseConfigurationStatus.toString();
        return this;
    }

    public List<String> getLicenseRules() {
        return this.licenseRules;
    }

    public void setLicenseRules(Collection<String> licenseRules) {
        if (licenseRules == null) {
            this.licenseRules = null;
            return;
        }
        this.licenseRules = new ArrayList<String>(licenseRules);
    }

    public UpdateLicenseConfigurationRequest withLicenseRules(String ... licenseRules) {
        if (this.licenseRules == null) {
            this.setLicenseRules(new ArrayList<String>(licenseRules.length));
        }
        for (String ele : licenseRules) {
            this.licenseRules.add(ele);
        }
        return this;
    }

    public UpdateLicenseConfigurationRequest withLicenseRules(Collection<String> licenseRules) {
        this.setLicenseRules(licenseRules);
        return this;
    }

    public void setLicenseCount(Long licenseCount) {
        this.licenseCount = licenseCount;
    }

    public Long getLicenseCount() {
        return this.licenseCount;
    }

    public UpdateLicenseConfigurationRequest withLicenseCount(Long licenseCount) {
        this.setLicenseCount(licenseCount);
        return this;
    }

    public void setLicenseCountHardLimit(Boolean licenseCountHardLimit) {
        this.licenseCountHardLimit = licenseCountHardLimit;
    }

    public Boolean getLicenseCountHardLimit() {
        return this.licenseCountHardLimit;
    }

    public UpdateLicenseConfigurationRequest withLicenseCountHardLimit(Boolean licenseCountHardLimit) {
        this.setLicenseCountHardLimit(licenseCountHardLimit);
        return this;
    }

    public Boolean isLicenseCountHardLimit() {
        return this.licenseCountHardLimit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateLicenseConfigurationRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateLicenseConfigurationRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<ProductInformation> getProductInformationList() {
        return this.productInformationList;
    }

    public void setProductInformationList(Collection<ProductInformation> productInformationList) {
        if (productInformationList == null) {
            this.productInformationList = null;
            return;
        }
        this.productInformationList = new ArrayList<ProductInformation>(productInformationList);
    }

    public UpdateLicenseConfigurationRequest withProductInformationList(ProductInformation ... productInformationList) {
        if (this.productInformationList == null) {
            this.setProductInformationList(new ArrayList<ProductInformation>(productInformationList.length));
        }
        for (ProductInformation ele : productInformationList) {
            this.productInformationList.add(ele);
        }
        return this;
    }

    public UpdateLicenseConfigurationRequest withProductInformationList(Collection<ProductInformation> productInformationList) {
        this.setProductInformationList(productInformationList);
        return this;
    }

    public void setDisassociateWhenNotFound(Boolean disassociateWhenNotFound) {
        this.disassociateWhenNotFound = disassociateWhenNotFound;
    }

    public Boolean getDisassociateWhenNotFound() {
        return this.disassociateWhenNotFound;
    }

    public UpdateLicenseConfigurationRequest withDisassociateWhenNotFound(Boolean disassociateWhenNotFound) {
        this.setDisassociateWhenNotFound(disassociateWhenNotFound);
        return this;
    }

    public Boolean isDisassociateWhenNotFound() {
        return this.disassociateWhenNotFound;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLicenseConfigurationArn() != null) {
            sb.append("LicenseConfigurationArn: ").append(this.getLicenseConfigurationArn()).append(",");
        }
        if (this.getLicenseConfigurationStatus() != null) {
            sb.append("LicenseConfigurationStatus: ").append(this.getLicenseConfigurationStatus()).append(",");
        }
        if (this.getLicenseRules() != null) {
            sb.append("LicenseRules: ").append(this.getLicenseRules()).append(",");
        }
        if (this.getLicenseCount() != null) {
            sb.append("LicenseCount: ").append(this.getLicenseCount()).append(",");
        }
        if (this.getLicenseCountHardLimit() != null) {
            sb.append("LicenseCountHardLimit: ").append(this.getLicenseCountHardLimit()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getProductInformationList() != null) {
            sb.append("ProductInformationList: ").append(this.getProductInformationList()).append(",");
        }
        if (this.getDisassociateWhenNotFound() != null) {
            sb.append("DisassociateWhenNotFound: ").append(this.getDisassociateWhenNotFound());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLicenseConfigurationRequest)) {
            return false;
        }
        UpdateLicenseConfigurationRequest other = (UpdateLicenseConfigurationRequest)obj;
        if (other.getLicenseConfigurationArn() == null ^ this.getLicenseConfigurationArn() == null) {
            return false;
        }
        if (other.getLicenseConfigurationArn() != null && !other.getLicenseConfigurationArn().equals(this.getLicenseConfigurationArn())) {
            return false;
        }
        if (other.getLicenseConfigurationStatus() == null ^ this.getLicenseConfigurationStatus() == null) {
            return false;
        }
        if (other.getLicenseConfigurationStatus() != null && !other.getLicenseConfigurationStatus().equals(this.getLicenseConfigurationStatus())) {
            return false;
        }
        if (other.getLicenseRules() == null ^ this.getLicenseRules() == null) {
            return false;
        }
        if (other.getLicenseRules() != null && !other.getLicenseRules().equals(this.getLicenseRules())) {
            return false;
        }
        if (other.getLicenseCount() == null ^ this.getLicenseCount() == null) {
            return false;
        }
        if (other.getLicenseCount() != null && !other.getLicenseCount().equals(this.getLicenseCount())) {
            return false;
        }
        if (other.getLicenseCountHardLimit() == null ^ this.getLicenseCountHardLimit() == null) {
            return false;
        }
        if (other.getLicenseCountHardLimit() != null && !other.getLicenseCountHardLimit().equals(this.getLicenseCountHardLimit())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getProductInformationList() == null ^ this.getProductInformationList() == null) {
            return false;
        }
        if (other.getProductInformationList() != null && !other.getProductInformationList().equals(this.getProductInformationList())) {
            return false;
        }
        if (other.getDisassociateWhenNotFound() == null ^ this.getDisassociateWhenNotFound() == null) {
            return false;
        }
        return other.getDisassociateWhenNotFound() == null || other.getDisassociateWhenNotFound().equals(this.getDisassociateWhenNotFound());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLicenseConfigurationArn() == null ? 0 : this.getLicenseConfigurationArn().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseConfigurationStatus() == null ? 0 : this.getLicenseConfigurationStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseRules() == null ? 0 : this.getLicenseRules().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseCount() == null ? 0 : this.getLicenseCount().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseCountHardLimit() == null ? 0 : this.getLicenseCountHardLimit().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getProductInformationList() == null ? 0 : this.getProductInformationList().hashCode());
        hashCode = 31 * hashCode + (this.getDisassociateWhenNotFound() == null ? 0 : this.getDisassociateWhenNotFound().hashCode());
        return hashCode;
    }

    public UpdateLicenseConfigurationRequest clone() {
        return (UpdateLicenseConfigurationRequest)super.clone();
    }
}

