/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntimev2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lexruntimev2.AmazonLexRuntimeV2Async;
import com.amazonaws.services.lexruntimev2.AmazonLexRuntimeV2AsyncClientBuilder;
import com.amazonaws.services.lexruntimev2.AmazonLexRuntimeV2Client;
import com.amazonaws.services.lexruntimev2.model.DeleteSessionRequest;
import com.amazonaws.services.lexruntimev2.model.DeleteSessionResult;
import com.amazonaws.services.lexruntimev2.model.GetSessionRequest;
import com.amazonaws.services.lexruntimev2.model.GetSessionResult;
import com.amazonaws.services.lexruntimev2.model.PutSessionRequest;
import com.amazonaws.services.lexruntimev2.model.PutSessionResult;
import com.amazonaws.services.lexruntimev2.model.RecognizeTextRequest;
import com.amazonaws.services.lexruntimev2.model.RecognizeTextResult;
import com.amazonaws.services.lexruntimev2.model.RecognizeUtteranceRequest;
import com.amazonaws.services.lexruntimev2.model.RecognizeUtteranceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonLexRuntimeV2AsyncClient
extends AmazonLexRuntimeV2Client
implements AmazonLexRuntimeV2Async {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonLexRuntimeV2AsyncClientBuilder asyncBuilder() {
        return AmazonLexRuntimeV2AsyncClientBuilder.standard();
    }

    AmazonLexRuntimeV2AsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonLexRuntimeV2AsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteSessionResult> deleteSessionAsync(DeleteSessionRequest request) {
        return this.deleteSessionAsync(request, null);
    }

    @Override
    public Future<DeleteSessionResult> deleteSessionAsync(DeleteSessionRequest request, final AsyncHandler<DeleteSessionRequest, DeleteSessionResult> asyncHandler) {
        final DeleteSessionRequest finalRequest = (DeleteSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSessionResult>(){

            @Override
            public DeleteSessionResult call() throws Exception {
                DeleteSessionResult result = null;
                try {
                    result = AmazonLexRuntimeV2AsyncClient.this.executeDeleteSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSessionResult> getSessionAsync(GetSessionRequest request) {
        return this.getSessionAsync(request, null);
    }

    @Override
    public Future<GetSessionResult> getSessionAsync(GetSessionRequest request, final AsyncHandler<GetSessionRequest, GetSessionResult> asyncHandler) {
        final GetSessionRequest finalRequest = (GetSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSessionResult>(){

            @Override
            public GetSessionResult call() throws Exception {
                GetSessionResult result = null;
                try {
                    result = AmazonLexRuntimeV2AsyncClient.this.executeGetSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutSessionResult> putSessionAsync(PutSessionRequest request) {
        return this.putSessionAsync(request, null);
    }

    @Override
    public Future<PutSessionResult> putSessionAsync(PutSessionRequest request, final AsyncHandler<PutSessionRequest, PutSessionResult> asyncHandler) {
        final PutSessionRequest finalRequest = (PutSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutSessionResult>(){

            @Override
            public PutSessionResult call() throws Exception {
                PutSessionResult result = null;
                try {
                    result = AmazonLexRuntimeV2AsyncClient.this.executePutSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RecognizeTextResult> recognizeTextAsync(RecognizeTextRequest request) {
        return this.recognizeTextAsync(request, null);
    }

    @Override
    public Future<RecognizeTextResult> recognizeTextAsync(RecognizeTextRequest request, final AsyncHandler<RecognizeTextRequest, RecognizeTextResult> asyncHandler) {
        final RecognizeTextRequest finalRequest = (RecognizeTextRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RecognizeTextResult>(){

            @Override
            public RecognizeTextResult call() throws Exception {
                RecognizeTextResult result = null;
                try {
                    result = AmazonLexRuntimeV2AsyncClient.this.executeRecognizeText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RecognizeUtteranceResult> recognizeUtteranceAsync(RecognizeUtteranceRequest request) {
        return this.recognizeUtteranceAsync(request, null);
    }

    @Override
    public Future<RecognizeUtteranceResult> recognizeUtteranceAsync(RecognizeUtteranceRequest request, final AsyncHandler<RecognizeUtteranceRequest, RecognizeUtteranceResult> asyncHandler) {
        final RecognizeUtteranceRequest finalRequest = (RecognizeUtteranceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RecognizeUtteranceResult>(){

            @Override
            public RecognizeUtteranceResult call() throws Exception {
                RecognizeUtteranceResult result = null;
                try {
                    result = AmazonLexRuntimeV2AsyncClient.this.executeRecognizeUtterance(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

