/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Details about the the configuration of the built-in <code>Amazon.QnAIntent</code>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/QnAIntentConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class QnAIntentConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
     * </p>
     */
    private DataSourceConfiguration dataSourceConfiguration;

    private BedrockModelSpecification bedrockModelConfiguration;

    /**
     * <p>
     * Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
     * </p>
     * 
     * @param dataSourceConfiguration
     *        Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
     */

    public void setDataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
        this.dataSourceConfiguration = dataSourceConfiguration;
    }

    /**
     * <p>
     * Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
     * </p>
     * 
     * @return Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
     */

    public DataSourceConfiguration getDataSourceConfiguration() {
        return this.dataSourceConfiguration;
    }

    /**
     * <p>
     * Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
     * </p>
     * 
     * @param dataSourceConfiguration
     *        Contains details about the configuration of the data source used for the <code>AMAZON.QnAIntent</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QnAIntentConfiguration withDataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
        setDataSourceConfiguration(dataSourceConfiguration);
        return this;
    }

    /**
     * @param bedrockModelConfiguration
     */

    public void setBedrockModelConfiguration(BedrockModelSpecification bedrockModelConfiguration) {
        this.bedrockModelConfiguration = bedrockModelConfiguration;
    }

    /**
     * @return
     */

    public BedrockModelSpecification getBedrockModelConfiguration() {
        return this.bedrockModelConfiguration;
    }

    /**
     * @param bedrockModelConfiguration
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public QnAIntentConfiguration withBedrockModelConfiguration(BedrockModelSpecification bedrockModelConfiguration) {
        setBedrockModelConfiguration(bedrockModelConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDataSourceConfiguration() != null)
            sb.append("DataSourceConfiguration: ").append(getDataSourceConfiguration()).append(",");
        if (getBedrockModelConfiguration() != null)
            sb.append("BedrockModelConfiguration: ").append(getBedrockModelConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof QnAIntentConfiguration == false)
            return false;
        QnAIntentConfiguration other = (QnAIntentConfiguration) obj;
        if (other.getDataSourceConfiguration() == null ^ this.getDataSourceConfiguration() == null)
            return false;
        if (other.getDataSourceConfiguration() != null && other.getDataSourceConfiguration().equals(this.getDataSourceConfiguration()) == false)
            return false;
        if (other.getBedrockModelConfiguration() == null ^ this.getBedrockModelConfiguration() == null)
            return false;
        if (other.getBedrockModelConfiguration() != null && other.getBedrockModelConfiguration().equals(this.getBedrockModelConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDataSourceConfiguration() == null) ? 0 : getDataSourceConfiguration().hashCode());
        hashCode = prime * hashCode + ((getBedrockModelConfiguration() == null) ? 0 : getBedrockModelConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public QnAIntentConfiguration clone() {
        try {
            return (QnAIntentConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.lexmodelsv2.model.transform.QnAIntentConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
