/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains details about the configuration of a Amazon Bedrock knowledge base.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/BedrockKnowledgeStoreConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BedrockKnowledgeStoreConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The base ARN of the knowledge base used.
     * </p>
     */
    private String bedrockKnowledgeBaseArn;
    /**
     * <p>
     * Specifies whether to return an exact response, or to return an answer generated by the model, using the fields
     * you specify from the database.
     * </p>
     */
    private Boolean exactResponse;
    /**
     * <p>
     * Contains the names of the fields used for an exact response to the user.
     * </p>
     */
    private BedrockKnowledgeStoreExactResponseFields exactResponseFields;

    /**
     * <p>
     * The base ARN of the knowledge base used.
     * </p>
     * 
     * @param bedrockKnowledgeBaseArn
     *        The base ARN of the knowledge base used.
     */

    public void setBedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn) {
        this.bedrockKnowledgeBaseArn = bedrockKnowledgeBaseArn;
    }

    /**
     * <p>
     * The base ARN of the knowledge base used.
     * </p>
     * 
     * @return The base ARN of the knowledge base used.
     */

    public String getBedrockKnowledgeBaseArn() {
        return this.bedrockKnowledgeBaseArn;
    }

    /**
     * <p>
     * The base ARN of the knowledge base used.
     * </p>
     * 
     * @param bedrockKnowledgeBaseArn
     *        The base ARN of the knowledge base used.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BedrockKnowledgeStoreConfiguration withBedrockKnowledgeBaseArn(String bedrockKnowledgeBaseArn) {
        setBedrockKnowledgeBaseArn(bedrockKnowledgeBaseArn);
        return this;
    }

    /**
     * <p>
     * Specifies whether to return an exact response, or to return an answer generated by the model, using the fields
     * you specify from the database.
     * </p>
     * 
     * @param exactResponse
     *        Specifies whether to return an exact response, or to return an answer generated by the model, using the
     *        fields you specify from the database.
     */

    public void setExactResponse(Boolean exactResponse) {
        this.exactResponse = exactResponse;
    }

    /**
     * <p>
     * Specifies whether to return an exact response, or to return an answer generated by the model, using the fields
     * you specify from the database.
     * </p>
     * 
     * @return Specifies whether to return an exact response, or to return an answer generated by the model, using the
     *         fields you specify from the database.
     */

    public Boolean getExactResponse() {
        return this.exactResponse;
    }

    /**
     * <p>
     * Specifies whether to return an exact response, or to return an answer generated by the model, using the fields
     * you specify from the database.
     * </p>
     * 
     * @param exactResponse
     *        Specifies whether to return an exact response, or to return an answer generated by the model, using the
     *        fields you specify from the database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BedrockKnowledgeStoreConfiguration withExactResponse(Boolean exactResponse) {
        setExactResponse(exactResponse);
        return this;
    }

    /**
     * <p>
     * Specifies whether to return an exact response, or to return an answer generated by the model, using the fields
     * you specify from the database.
     * </p>
     * 
     * @return Specifies whether to return an exact response, or to return an answer generated by the model, using the
     *         fields you specify from the database.
     */

    public Boolean isExactResponse() {
        return this.exactResponse;
    }

    /**
     * <p>
     * Contains the names of the fields used for an exact response to the user.
     * </p>
     * 
     * @param exactResponseFields
     *        Contains the names of the fields used for an exact response to the user.
     */

    public void setExactResponseFields(BedrockKnowledgeStoreExactResponseFields exactResponseFields) {
        this.exactResponseFields = exactResponseFields;
    }

    /**
     * <p>
     * Contains the names of the fields used for an exact response to the user.
     * </p>
     * 
     * @return Contains the names of the fields used for an exact response to the user.
     */

    public BedrockKnowledgeStoreExactResponseFields getExactResponseFields() {
        return this.exactResponseFields;
    }

    /**
     * <p>
     * Contains the names of the fields used for an exact response to the user.
     * </p>
     * 
     * @param exactResponseFields
     *        Contains the names of the fields used for an exact response to the user.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public BedrockKnowledgeStoreConfiguration withExactResponseFields(BedrockKnowledgeStoreExactResponseFields exactResponseFields) {
        setExactResponseFields(exactResponseFields);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBedrockKnowledgeBaseArn() != null)
            sb.append("BedrockKnowledgeBaseArn: ").append(getBedrockKnowledgeBaseArn()).append(",");
        if (getExactResponse() != null)
            sb.append("ExactResponse: ").append(getExactResponse()).append(",");
        if (getExactResponseFields() != null)
            sb.append("ExactResponseFields: ").append(getExactResponseFields());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof BedrockKnowledgeStoreConfiguration == false)
            return false;
        BedrockKnowledgeStoreConfiguration other = (BedrockKnowledgeStoreConfiguration) obj;
        if (other.getBedrockKnowledgeBaseArn() == null ^ this.getBedrockKnowledgeBaseArn() == null)
            return false;
        if (other.getBedrockKnowledgeBaseArn() != null && other.getBedrockKnowledgeBaseArn().equals(this.getBedrockKnowledgeBaseArn()) == false)
            return false;
        if (other.getExactResponse() == null ^ this.getExactResponse() == null)
            return false;
        if (other.getExactResponse() != null && other.getExactResponse().equals(this.getExactResponse()) == false)
            return false;
        if (other.getExactResponseFields() == null ^ this.getExactResponseFields() == null)
            return false;
        if (other.getExactResponseFields() != null && other.getExactResponseFields().equals(this.getExactResponseFields()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBedrockKnowledgeBaseArn() == null) ? 0 : getBedrockKnowledgeBaseArn().hashCode());
        hashCode = prime * hashCode + ((getExactResponse() == null) ? 0 : getExactResponse().hashCode());
        hashCode = prime * hashCode + ((getExactResponseFields() == null) ? 0 : getExactResponseFields().hashCode());
        return hashCode;
    }

    @Override
    public BedrockKnowledgeStoreConfiguration clone() {
        try {
            return (BedrockKnowledgeStoreConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.lexmodelsv2.model.transform.BedrockKnowledgeStoreConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
