/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lexruntime.AmazonLexRuntime;
import com.amazonaws.services.lexruntime.AmazonLexRuntimeClientBuilder;
import com.amazonaws.services.lexruntime.model.AmazonLexRuntimeException;
import com.amazonaws.services.lexruntime.model.DeleteSessionRequest;
import com.amazonaws.services.lexruntime.model.DeleteSessionResult;
import com.amazonaws.services.lexruntime.model.GetSessionRequest;
import com.amazonaws.services.lexruntime.model.GetSessionResult;
import com.amazonaws.services.lexruntime.model.PostContentRequest;
import com.amazonaws.services.lexruntime.model.PostContentResult;
import com.amazonaws.services.lexruntime.model.PostTextRequest;
import com.amazonaws.services.lexruntime.model.PostTextResult;
import com.amazonaws.services.lexruntime.model.PutSessionRequest;
import com.amazonaws.services.lexruntime.model.PutSessionResult;
import com.amazonaws.services.lexruntime.model.transform.BadGatewayExceptionUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.DeleteSessionRequestProtocolMarshaller;
import com.amazonaws.services.lexruntime.model.transform.DeleteSessionResultJsonUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.DependencyFailedExceptionUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.GetSessionRequestProtocolMarshaller;
import com.amazonaws.services.lexruntime.model.transform.GetSessionResultJsonUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.InternalFailureExceptionUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.LoopDetectedExceptionUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.NotAcceptableExceptionUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.PostContentRequestProtocolMarshaller;
import com.amazonaws.services.lexruntime.model.transform.PostContentResultJsonUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.PostTextRequestProtocolMarshaller;
import com.amazonaws.services.lexruntime.model.transform.PostTextResultJsonUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.PutSessionRequestProtocolMarshaller;
import com.amazonaws.services.lexruntime.model.transform.PutSessionResultJsonUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.RequestTimeoutExceptionUnmarshaller;
import com.amazonaws.services.lexruntime.model.transform.UnsupportedMediaTypeExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonLexRuntimeClient
extends AmazonWebServiceClient
implements AmazonLexRuntime {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonLexRuntime.class);
    private static final String DEFAULT_SIGNING_NAME = "lex";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalFailureExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestTimeoutException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RequestTimeoutExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DependencyFailedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DependencyFailedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedMediaTypeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedMediaTypeExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotAcceptableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotAcceptableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadGatewayException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadGatewayExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LoopDetectedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LoopDetectedExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonLexRuntimeException.class));

    public static AmazonLexRuntimeClientBuilder builder() {
        return AmazonLexRuntimeClientBuilder.standard();
    }

    AmazonLexRuntimeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonLexRuntimeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("runtime.lex");
        this.setEndpoint("runtime.lex.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/lexruntime/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/lexruntime/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteSessionResult deleteSession(DeleteSessionRequest request) {
        request = (DeleteSessionRequest)this.beforeClientExecution(request);
        return this.executeDeleteSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSessionResult executeDeleteSession(DeleteSessionRequest deleteSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSessionRequestProtocolMarshaller(protocolFactory).marshall((DeleteSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Lex Runtime Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSessionResult deleteSessionResult = (DeleteSessionResult)response.getAwsResponse();
            return deleteSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetSessionResult getSession(GetSessionRequest request) {
        request = (GetSessionRequest)this.beforeClientExecution(request);
        return this.executeGetSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetSessionResult executeGetSession(GetSessionRequest getSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSessionRequestProtocolMarshaller(protocolFactory).marshall((GetSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Lex Runtime Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetSessionResult getSessionResult = (GetSessionResult)response.getAwsResponse();
            return getSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PostContentResult postContent(PostContentRequest request) {
        request = (PostContentRequest)this.beforeClientExecution(request);
        return this.executePostContent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PostContentResult executePostContent(PostContentRequest postContentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(postContentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PostContentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PostContentRequestProtocolMarshaller(protocolFactory).marshall((PostContentRequest)super.beforeMarshalling((AmazonWebServiceRequest)postContentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Lex Runtime Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PostContent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT, (Object)Boolean.TRUE);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new PostContentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, (Object)Boolean.TRUE);
            PostContentResult postContentResult = (PostContentResult)response.getAwsResponse();
            return postContentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PostTextResult postText(PostTextRequest request) {
        request = (PostTextRequest)this.beforeClientExecution(request);
        return this.executePostText(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PostTextResult executePostText(PostTextRequest postTextRequest) {
        ExecutionContext executionContext = this.createExecutionContext(postTextRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PostTextRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PostTextRequestProtocolMarshaller(protocolFactory).marshall((PostTextRequest)super.beforeMarshalling((AmazonWebServiceRequest)postTextRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Lex Runtime Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PostText");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PostTextResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PostTextResult postTextResult = (PostTextResult)response.getAwsResponse();
            return postTextResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutSessionResult putSession(PutSessionRequest request) {
        request = (PutSessionRequest)this.beforeClientExecution(request);
        return this.executePutSession(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutSessionResult executePutSession(PutSessionRequest putSessionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putSessionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutSessionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutSessionRequestProtocolMarshaller(protocolFactory).marshall((PutSessionRequest)super.beforeMarshalling((AmazonWebServiceRequest)putSessionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Lex Runtime Service");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutSession");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new PutSessionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            request.addHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT, (Object)Boolean.TRUE);
            PutSessionResult putSessionResult = (PutSessionResult)response.getAwsResponse();
            return putSessionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

