/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntime.model.ConfirmationStatus;
import com.amazonaws.services.lexruntime.model.DialogActionType;
import com.amazonaws.services.lexruntime.model.FulfillmentState;
import com.amazonaws.services.lexruntime.model.transform.IntentSummaryMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class IntentSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String intentName;
    private Map<String, String> slots;
    private String confirmationStatus;
    private String dialogActionType;
    private String fulfillmentState;
    private String slotToElicit;

    public void setIntentName(String intentName) {
        this.intentName = intentName;
    }

    public String getIntentName() {
        return this.intentName;
    }

    public IntentSummary withIntentName(String intentName) {
        this.setIntentName(intentName);
        return this;
    }

    public Map<String, String> getSlots() {
        return this.slots;
    }

    public void setSlots(Map<String, String> slots) {
        this.slots = slots;
    }

    public IntentSummary withSlots(Map<String, String> slots) {
        this.setSlots(slots);
        return this;
    }

    public IntentSummary addSlotsEntry(String key, String value) {
        if (null == this.slots) {
            this.slots = new HashMap<String, String>();
        }
        if (this.slots.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.slots.put(key, value);
        return this;
    }

    public IntentSummary clearSlotsEntries() {
        this.slots = null;
        return this;
    }

    public void setConfirmationStatus(String confirmationStatus) {
        this.confirmationStatus = confirmationStatus;
    }

    public String getConfirmationStatus() {
        return this.confirmationStatus;
    }

    public IntentSummary withConfirmationStatus(String confirmationStatus) {
        this.setConfirmationStatus(confirmationStatus);
        return this;
    }

    public IntentSummary withConfirmationStatus(ConfirmationStatus confirmationStatus) {
        this.confirmationStatus = confirmationStatus.toString();
        return this;
    }

    public void setDialogActionType(String dialogActionType) {
        this.dialogActionType = dialogActionType;
    }

    public String getDialogActionType() {
        return this.dialogActionType;
    }

    public IntentSummary withDialogActionType(String dialogActionType) {
        this.setDialogActionType(dialogActionType);
        return this;
    }

    public IntentSummary withDialogActionType(DialogActionType dialogActionType) {
        this.dialogActionType = dialogActionType.toString();
        return this;
    }

    public void setFulfillmentState(String fulfillmentState) {
        this.fulfillmentState = fulfillmentState;
    }

    public String getFulfillmentState() {
        return this.fulfillmentState;
    }

    public IntentSummary withFulfillmentState(String fulfillmentState) {
        this.setFulfillmentState(fulfillmentState);
        return this;
    }

    public IntentSummary withFulfillmentState(FulfillmentState fulfillmentState) {
        this.fulfillmentState = fulfillmentState.toString();
        return this;
    }

    public void setSlotToElicit(String slotToElicit) {
        this.slotToElicit = slotToElicit;
    }

    public String getSlotToElicit() {
        return this.slotToElicit;
    }

    public IntentSummary withSlotToElicit(String slotToElicit) {
        this.setSlotToElicit(slotToElicit);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIntentName() != null) {
            sb.append("IntentName: ").append(this.getIntentName()).append(",");
        }
        if (this.getSlots() != null) {
            sb.append("Slots: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getConfirmationStatus() != null) {
            sb.append("ConfirmationStatus: ").append(this.getConfirmationStatus()).append(",");
        }
        if (this.getDialogActionType() != null) {
            sb.append("DialogActionType: ").append(this.getDialogActionType()).append(",");
        }
        if (this.getFulfillmentState() != null) {
            sb.append("FulfillmentState: ").append(this.getFulfillmentState()).append(",");
        }
        if (this.getSlotToElicit() != null) {
            sb.append("SlotToElicit: ").append(this.getSlotToElicit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentSummary)) {
            return false;
        }
        IntentSummary other = (IntentSummary)obj;
        if (other.getIntentName() == null ^ this.getIntentName() == null) {
            return false;
        }
        if (other.getIntentName() != null && !other.getIntentName().equals(this.getIntentName())) {
            return false;
        }
        if (other.getSlots() == null ^ this.getSlots() == null) {
            return false;
        }
        if (other.getSlots() != null && !other.getSlots().equals(this.getSlots())) {
            return false;
        }
        if (other.getConfirmationStatus() == null ^ this.getConfirmationStatus() == null) {
            return false;
        }
        if (other.getConfirmationStatus() != null && !other.getConfirmationStatus().equals(this.getConfirmationStatus())) {
            return false;
        }
        if (other.getDialogActionType() == null ^ this.getDialogActionType() == null) {
            return false;
        }
        if (other.getDialogActionType() != null && !other.getDialogActionType().equals(this.getDialogActionType())) {
            return false;
        }
        if (other.getFulfillmentState() == null ^ this.getFulfillmentState() == null) {
            return false;
        }
        if (other.getFulfillmentState() != null && !other.getFulfillmentState().equals(this.getFulfillmentState())) {
            return false;
        }
        if (other.getSlotToElicit() == null ^ this.getSlotToElicit() == null) {
            return false;
        }
        return other.getSlotToElicit() == null || other.getSlotToElicit().equals(this.getSlotToElicit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIntentName() == null ? 0 : this.getIntentName().hashCode());
        hashCode = 31 * hashCode + (this.getSlots() == null ? 0 : this.getSlots().hashCode());
        hashCode = 31 * hashCode + (this.getConfirmationStatus() == null ? 0 : this.getConfirmationStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDialogActionType() == null ? 0 : this.getDialogActionType().hashCode());
        hashCode = 31 * hashCode + (this.getFulfillmentState() == null ? 0 : this.getFulfillmentState().hashCode());
        hashCode = 31 * hashCode + (this.getSlotToElicit() == null ? 0 : this.getSlotToElicit().hashCode());
        return hashCode;
    }

    public IntentSummary clone() {
        try {
            return (IntentSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IntentSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

