/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lambda.model.LayerVersionContentInput;
import java.nio.ByteBuffer;

@SdkInternalApi
public class LayerVersionContentInputMarshaller {
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").build();
    private static final MarshallingInfo<String> S3KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Key").build();
    private static final MarshallingInfo<String> S3OBJECTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ObjectVersion").build();
    private static final MarshallingInfo<ByteBuffer> ZIPFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZipFile").build();
    private static final LayerVersionContentInputMarshaller instance = new LayerVersionContentInputMarshaller();

    public static LayerVersionContentInputMarshaller getInstance() {
        return instance;
    }

    public void marshall(LayerVersionContentInput layerVersionContentInput, ProtocolMarshaller protocolMarshaller) {
        if (layerVersionContentInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)layerVersionContentInput.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)layerVersionContentInput.getS3Key(), S3KEY_BINDING);
            protocolMarshaller.marshall((Object)layerVersionContentInput.getS3ObjectVersion(), S3OBJECTVERSION_BINDING);
            protocolMarshaller.marshall((Object)layerVersionContentInput.getZipFile(), ZIPFILE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

