/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lambda.model.Architecture;
import com.amazonaws.services.lambda.model.DeadLetterConfig;
import com.amazonaws.services.lambda.model.EnvironmentResponse;
import com.amazonaws.services.lambda.model.EphemeralStorage;
import com.amazonaws.services.lambda.model.FileSystemConfig;
import com.amazonaws.services.lambda.model.ImageConfigResponse;
import com.amazonaws.services.lambda.model.LastUpdateStatus;
import com.amazonaws.services.lambda.model.LastUpdateStatusReasonCode;
import com.amazonaws.services.lambda.model.Layer;
import com.amazonaws.services.lambda.model.LoggingConfig;
import com.amazonaws.services.lambda.model.PackageType;
import com.amazonaws.services.lambda.model.Runtime;
import com.amazonaws.services.lambda.model.RuntimeVersionConfig;
import com.amazonaws.services.lambda.model.SnapStartResponse;
import com.amazonaws.services.lambda.model.State;
import com.amazonaws.services.lambda.model.StateReasonCode;
import com.amazonaws.services.lambda.model.TracingConfigResponse;
import com.amazonaws.services.lambda.model.VpcConfigResponse;
import com.amazonaws.services.lambda.model.transform.FunctionConfigurationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class FunctionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String functionName;
    private String functionArn;
    private String runtime;
    private String role;
    private String handler;
    private Long codeSize;
    private String description;
    private Integer timeout;
    private Integer memorySize;
    private String lastModified;
    private String codeSha256;
    private String version;
    private VpcConfigResponse vpcConfig;
    private DeadLetterConfig deadLetterConfig;
    private EnvironmentResponse environment;
    private String kMSKeyArn;
    private TracingConfigResponse tracingConfig;
    private String masterArn;
    private String revisionId;
    private SdkInternalList<Layer> layers;
    private String state;
    private String stateReason;
    private String stateReasonCode;
    private String lastUpdateStatus;
    private String lastUpdateStatusReason;
    private String lastUpdateStatusReasonCode;
    private SdkInternalList<FileSystemConfig> fileSystemConfigs;
    private String packageType;
    private ImageConfigResponse imageConfigResponse;
    private String signingProfileVersionArn;
    private String signingJobArn;
    private SdkInternalList<String> architectures;
    private EphemeralStorage ephemeralStorage;
    private SnapStartResponse snapStart;
    private RuntimeVersionConfig runtimeVersionConfig;
    private LoggingConfig loggingConfig;

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public FunctionConfiguration withFunctionName(String functionName) {
        this.setFunctionName(functionName);
        return this;
    }

    public void setFunctionArn(String functionArn) {
        this.functionArn = functionArn;
    }

    public String getFunctionArn() {
        return this.functionArn;
    }

    public FunctionConfiguration withFunctionArn(String functionArn) {
        this.setFunctionArn(functionArn);
        return this;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public FunctionConfiguration withRuntime(String runtime) {
        this.setRuntime(runtime);
        return this;
    }

    public void setRuntime(Runtime runtime) {
        this.withRuntime(runtime);
    }

    public FunctionConfiguration withRuntime(Runtime runtime) {
        this.runtime = runtime.toString();
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public FunctionConfiguration withRole(String role) {
        this.setRole(role);
        return this;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public String getHandler() {
        return this.handler;
    }

    public FunctionConfiguration withHandler(String handler) {
        this.setHandler(handler);
        return this;
    }

    public void setCodeSize(Long codeSize) {
        this.codeSize = codeSize;
    }

    public Long getCodeSize() {
        return this.codeSize;
    }

    public FunctionConfiguration withCodeSize(Long codeSize) {
        this.setCodeSize(codeSize);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public FunctionConfiguration withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public FunctionConfiguration withTimeout(Integer timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public void setMemorySize(Integer memorySize) {
        this.memorySize = memorySize;
    }

    public Integer getMemorySize() {
        return this.memorySize;
    }

    public FunctionConfiguration withMemorySize(Integer memorySize) {
        this.setMemorySize(memorySize);
        return this;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public FunctionConfiguration withLastModified(String lastModified) {
        this.setLastModified(lastModified);
        return this;
    }

    public void setCodeSha256(String codeSha256) {
        this.codeSha256 = codeSha256;
    }

    public String getCodeSha256() {
        return this.codeSha256;
    }

    public FunctionConfiguration withCodeSha256(String codeSha256) {
        this.setCodeSha256(codeSha256);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public FunctionConfiguration withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setVpcConfig(VpcConfigResponse vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfigResponse getVpcConfig() {
        return this.vpcConfig;
    }

    public FunctionConfiguration withVpcConfig(VpcConfigResponse vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setDeadLetterConfig(DeadLetterConfig deadLetterConfig) {
        this.deadLetterConfig = deadLetterConfig;
    }

    public DeadLetterConfig getDeadLetterConfig() {
        return this.deadLetterConfig;
    }

    public FunctionConfiguration withDeadLetterConfig(DeadLetterConfig deadLetterConfig) {
        this.setDeadLetterConfig(deadLetterConfig);
        return this;
    }

    public void setEnvironment(EnvironmentResponse environment) {
        this.environment = environment;
    }

    public EnvironmentResponse getEnvironment() {
        return this.environment;
    }

    public FunctionConfiguration withEnvironment(EnvironmentResponse environment) {
        this.setEnvironment(environment);
        return this;
    }

    public void setKMSKeyArn(String kMSKeyArn) {
        this.kMSKeyArn = kMSKeyArn;
    }

    public String getKMSKeyArn() {
        return this.kMSKeyArn;
    }

    public FunctionConfiguration withKMSKeyArn(String kMSKeyArn) {
        this.setKMSKeyArn(kMSKeyArn);
        return this;
    }

    public void setTracingConfig(TracingConfigResponse tracingConfig) {
        this.tracingConfig = tracingConfig;
    }

    public TracingConfigResponse getTracingConfig() {
        return this.tracingConfig;
    }

    public FunctionConfiguration withTracingConfig(TracingConfigResponse tracingConfig) {
        this.setTracingConfig(tracingConfig);
        return this;
    }

    public void setMasterArn(String masterArn) {
        this.masterArn = masterArn;
    }

    public String getMasterArn() {
        return this.masterArn;
    }

    public FunctionConfiguration withMasterArn(String masterArn) {
        this.setMasterArn(masterArn);
        return this;
    }

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public FunctionConfiguration withRevisionId(String revisionId) {
        this.setRevisionId(revisionId);
        return this;
    }

    public List<Layer> getLayers() {
        if (this.layers == null) {
            this.layers = new SdkInternalList();
        }
        return this.layers;
    }

    public void setLayers(Collection<Layer> layers) {
        if (layers == null) {
            this.layers = null;
            return;
        }
        this.layers = new SdkInternalList(layers);
    }

    public FunctionConfiguration withLayers(Layer ... layers) {
        if (this.layers == null) {
            this.setLayers((Collection<Layer>)new SdkInternalList(layers.length));
        }
        for (Layer ele : layers) {
            this.layers.add((Object)ele);
        }
        return this;
    }

    public FunctionConfiguration withLayers(Collection<Layer> layers) {
        this.setLayers(layers);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public FunctionConfiguration withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(State state) {
        this.withState(state);
    }

    public FunctionConfiguration withState(State state) {
        this.state = state.toString();
        return this;
    }

    public void setStateReason(String stateReason) {
        this.stateReason = stateReason;
    }

    public String getStateReason() {
        return this.stateReason;
    }

    public FunctionConfiguration withStateReason(String stateReason) {
        this.setStateReason(stateReason);
        return this;
    }

    public void setStateReasonCode(String stateReasonCode) {
        this.stateReasonCode = stateReasonCode;
    }

    public String getStateReasonCode() {
        return this.stateReasonCode;
    }

    public FunctionConfiguration withStateReasonCode(String stateReasonCode) {
        this.setStateReasonCode(stateReasonCode);
        return this;
    }

    public void setStateReasonCode(StateReasonCode stateReasonCode) {
        this.withStateReasonCode(stateReasonCode);
    }

    public FunctionConfiguration withStateReasonCode(StateReasonCode stateReasonCode) {
        this.stateReasonCode = stateReasonCode.toString();
        return this;
    }

    public void setLastUpdateStatus(String lastUpdateStatus) {
        this.lastUpdateStatus = lastUpdateStatus;
    }

    public String getLastUpdateStatus() {
        return this.lastUpdateStatus;
    }

    public FunctionConfiguration withLastUpdateStatus(String lastUpdateStatus) {
        this.setLastUpdateStatus(lastUpdateStatus);
        return this;
    }

    public void setLastUpdateStatus(LastUpdateStatus lastUpdateStatus) {
        this.withLastUpdateStatus(lastUpdateStatus);
    }

    public FunctionConfiguration withLastUpdateStatus(LastUpdateStatus lastUpdateStatus) {
        this.lastUpdateStatus = lastUpdateStatus.toString();
        return this;
    }

    public void setLastUpdateStatusReason(String lastUpdateStatusReason) {
        this.lastUpdateStatusReason = lastUpdateStatusReason;
    }

    public String getLastUpdateStatusReason() {
        return this.lastUpdateStatusReason;
    }

    public FunctionConfiguration withLastUpdateStatusReason(String lastUpdateStatusReason) {
        this.setLastUpdateStatusReason(lastUpdateStatusReason);
        return this;
    }

    public void setLastUpdateStatusReasonCode(String lastUpdateStatusReasonCode) {
        this.lastUpdateStatusReasonCode = lastUpdateStatusReasonCode;
    }

    public String getLastUpdateStatusReasonCode() {
        return this.lastUpdateStatusReasonCode;
    }

    public FunctionConfiguration withLastUpdateStatusReasonCode(String lastUpdateStatusReasonCode) {
        this.setLastUpdateStatusReasonCode(lastUpdateStatusReasonCode);
        return this;
    }

    public void setLastUpdateStatusReasonCode(LastUpdateStatusReasonCode lastUpdateStatusReasonCode) {
        this.withLastUpdateStatusReasonCode(lastUpdateStatusReasonCode);
    }

    public FunctionConfiguration withLastUpdateStatusReasonCode(LastUpdateStatusReasonCode lastUpdateStatusReasonCode) {
        this.lastUpdateStatusReasonCode = lastUpdateStatusReasonCode.toString();
        return this;
    }

    public List<FileSystemConfig> getFileSystemConfigs() {
        if (this.fileSystemConfigs == null) {
            this.fileSystemConfigs = new SdkInternalList();
        }
        return this.fileSystemConfigs;
    }

    public void setFileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs) {
        if (fileSystemConfigs == null) {
            this.fileSystemConfigs = null;
            return;
        }
        this.fileSystemConfigs = new SdkInternalList(fileSystemConfigs);
    }

    public FunctionConfiguration withFileSystemConfigs(FileSystemConfig ... fileSystemConfigs) {
        if (this.fileSystemConfigs == null) {
            this.setFileSystemConfigs((Collection<FileSystemConfig>)new SdkInternalList(fileSystemConfigs.length));
        }
        for (FileSystemConfig ele : fileSystemConfigs) {
            this.fileSystemConfigs.add((Object)ele);
        }
        return this;
    }

    public FunctionConfiguration withFileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs) {
        this.setFileSystemConfigs(fileSystemConfigs);
        return this;
    }

    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public FunctionConfiguration withPackageType(String packageType) {
        this.setPackageType(packageType);
        return this;
    }

    public void setPackageType(PackageType packageType) {
        this.withPackageType(packageType);
    }

    public FunctionConfiguration withPackageType(PackageType packageType) {
        this.packageType = packageType.toString();
        return this;
    }

    public void setImageConfigResponse(ImageConfigResponse imageConfigResponse) {
        this.imageConfigResponse = imageConfigResponse;
    }

    public ImageConfigResponse getImageConfigResponse() {
        return this.imageConfigResponse;
    }

    public FunctionConfiguration withImageConfigResponse(ImageConfigResponse imageConfigResponse) {
        this.setImageConfigResponse(imageConfigResponse);
        return this;
    }

    public void setSigningProfileVersionArn(String signingProfileVersionArn) {
        this.signingProfileVersionArn = signingProfileVersionArn;
    }

    public String getSigningProfileVersionArn() {
        return this.signingProfileVersionArn;
    }

    public FunctionConfiguration withSigningProfileVersionArn(String signingProfileVersionArn) {
        this.setSigningProfileVersionArn(signingProfileVersionArn);
        return this;
    }

    public void setSigningJobArn(String signingJobArn) {
        this.signingJobArn = signingJobArn;
    }

    public String getSigningJobArn() {
        return this.signingJobArn;
    }

    public FunctionConfiguration withSigningJobArn(String signingJobArn) {
        this.setSigningJobArn(signingJobArn);
        return this;
    }

    public List<String> getArchitectures() {
        if (this.architectures == null) {
            this.architectures = new SdkInternalList();
        }
        return this.architectures;
    }

    public void setArchitectures(Collection<String> architectures) {
        if (architectures == null) {
            this.architectures = null;
            return;
        }
        this.architectures = new SdkInternalList(architectures);
    }

    public FunctionConfiguration withArchitectures(String ... architectures) {
        if (this.architectures == null) {
            this.setArchitectures((Collection<String>)new SdkInternalList(architectures.length));
        }
        for (String ele : architectures) {
            this.architectures.add((Object)ele);
        }
        return this;
    }

    public FunctionConfiguration withArchitectures(Collection<String> architectures) {
        this.setArchitectures(architectures);
        return this;
    }

    public FunctionConfiguration withArchitectures(Architecture ... architectures) {
        SdkInternalList architecturesCopy = new SdkInternalList(architectures.length);
        for (Architecture value : architectures) {
            architecturesCopy.add((Object)value.toString());
        }
        if (this.getArchitectures() == null) {
            this.setArchitectures((Collection<String>)architecturesCopy);
        } else {
            this.getArchitectures().addAll((Collection<String>)architecturesCopy);
        }
        return this;
    }

    public void setEphemeralStorage(EphemeralStorage ephemeralStorage) {
        this.ephemeralStorage = ephemeralStorage;
    }

    public EphemeralStorage getEphemeralStorage() {
        return this.ephemeralStorage;
    }

    public FunctionConfiguration withEphemeralStorage(EphemeralStorage ephemeralStorage) {
        this.setEphemeralStorage(ephemeralStorage);
        return this;
    }

    public void setSnapStart(SnapStartResponse snapStart) {
        this.snapStart = snapStart;
    }

    public SnapStartResponse getSnapStart() {
        return this.snapStart;
    }

    public FunctionConfiguration withSnapStart(SnapStartResponse snapStart) {
        this.setSnapStart(snapStart);
        return this;
    }

    public void setRuntimeVersionConfig(RuntimeVersionConfig runtimeVersionConfig) {
        this.runtimeVersionConfig = runtimeVersionConfig;
    }

    public RuntimeVersionConfig getRuntimeVersionConfig() {
        return this.runtimeVersionConfig;
    }

    public FunctionConfiguration withRuntimeVersionConfig(RuntimeVersionConfig runtimeVersionConfig) {
        this.setRuntimeVersionConfig(runtimeVersionConfig);
        return this;
    }

    public void setLoggingConfig(LoggingConfig loggingConfig) {
        this.loggingConfig = loggingConfig;
    }

    public LoggingConfig getLoggingConfig() {
        return this.loggingConfig;
    }

    public FunctionConfiguration withLoggingConfig(LoggingConfig loggingConfig) {
        this.setLoggingConfig(loggingConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctionName() != null) {
            sb.append("FunctionName: ").append(this.getFunctionName()).append(",");
        }
        if (this.getFunctionArn() != null) {
            sb.append("FunctionArn: ").append(this.getFunctionArn()).append(",");
        }
        if (this.getRuntime() != null) {
            sb.append("Runtime: ").append(this.getRuntime()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getHandler() != null) {
            sb.append("Handler: ").append(this.getHandler()).append(",");
        }
        if (this.getCodeSize() != null) {
            sb.append("CodeSize: ").append(this.getCodeSize()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTimeout() != null) {
            sb.append("Timeout: ").append(this.getTimeout()).append(",");
        }
        if (this.getMemorySize() != null) {
            sb.append("MemorySize: ").append(this.getMemorySize()).append(",");
        }
        if (this.getLastModified() != null) {
            sb.append("LastModified: ").append(this.getLastModified()).append(",");
        }
        if (this.getCodeSha256() != null) {
            sb.append("CodeSha256: ").append(this.getCodeSha256()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getDeadLetterConfig() != null) {
            sb.append("DeadLetterConfig: ").append(this.getDeadLetterConfig()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getKMSKeyArn() != null) {
            sb.append("KMSKeyArn: ").append(this.getKMSKeyArn()).append(",");
        }
        if (this.getTracingConfig() != null) {
            sb.append("TracingConfig: ").append(this.getTracingConfig()).append(",");
        }
        if (this.getMasterArn() != null) {
            sb.append("MasterArn: ").append(this.getMasterArn()).append(",");
        }
        if (this.getRevisionId() != null) {
            sb.append("RevisionId: ").append(this.getRevisionId()).append(",");
        }
        if (this.getLayers() != null) {
            sb.append("Layers: ").append(this.getLayers()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStateReason() != null) {
            sb.append("StateReason: ").append(this.getStateReason()).append(",");
        }
        if (this.getStateReasonCode() != null) {
            sb.append("StateReasonCode: ").append(this.getStateReasonCode()).append(",");
        }
        if (this.getLastUpdateStatus() != null) {
            sb.append("LastUpdateStatus: ").append(this.getLastUpdateStatus()).append(",");
        }
        if (this.getLastUpdateStatusReason() != null) {
            sb.append("LastUpdateStatusReason: ").append(this.getLastUpdateStatusReason()).append(",");
        }
        if (this.getLastUpdateStatusReasonCode() != null) {
            sb.append("LastUpdateStatusReasonCode: ").append(this.getLastUpdateStatusReasonCode()).append(",");
        }
        if (this.getFileSystemConfigs() != null) {
            sb.append("FileSystemConfigs: ").append(this.getFileSystemConfigs()).append(",");
        }
        if (this.getPackageType() != null) {
            sb.append("PackageType: ").append(this.getPackageType()).append(",");
        }
        if (this.getImageConfigResponse() != null) {
            sb.append("ImageConfigResponse: ").append(this.getImageConfigResponse()).append(",");
        }
        if (this.getSigningProfileVersionArn() != null) {
            sb.append("SigningProfileVersionArn: ").append(this.getSigningProfileVersionArn()).append(",");
        }
        if (this.getSigningJobArn() != null) {
            sb.append("SigningJobArn: ").append(this.getSigningJobArn()).append(",");
        }
        if (this.getArchitectures() != null) {
            sb.append("Architectures: ").append(this.getArchitectures()).append(",");
        }
        if (this.getEphemeralStorage() != null) {
            sb.append("EphemeralStorage: ").append(this.getEphemeralStorage()).append(",");
        }
        if (this.getSnapStart() != null) {
            sb.append("SnapStart: ").append(this.getSnapStart()).append(",");
        }
        if (this.getRuntimeVersionConfig() != null) {
            sb.append("RuntimeVersionConfig: ").append(this.getRuntimeVersionConfig()).append(",");
        }
        if (this.getLoggingConfig() != null) {
            sb.append("LoggingConfig: ").append(this.getLoggingConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfiguration)) {
            return false;
        }
        FunctionConfiguration other = (FunctionConfiguration)obj;
        if (other.getFunctionName() == null ^ this.getFunctionName() == null) {
            return false;
        }
        if (other.getFunctionName() != null && !other.getFunctionName().equals(this.getFunctionName())) {
            return false;
        }
        if (other.getFunctionArn() == null ^ this.getFunctionArn() == null) {
            return false;
        }
        if (other.getFunctionArn() != null && !other.getFunctionArn().equals(this.getFunctionArn())) {
            return false;
        }
        if (other.getRuntime() == null ^ this.getRuntime() == null) {
            return false;
        }
        if (other.getRuntime() != null && !other.getRuntime().equals(this.getRuntime())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getHandler() == null ^ this.getHandler() == null) {
            return false;
        }
        if (other.getHandler() != null && !other.getHandler().equals(this.getHandler())) {
            return false;
        }
        if (other.getCodeSize() == null ^ this.getCodeSize() == null) {
            return false;
        }
        if (other.getCodeSize() != null && !other.getCodeSize().equals(this.getCodeSize())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTimeout() == null ^ this.getTimeout() == null) {
            return false;
        }
        if (other.getTimeout() != null && !other.getTimeout().equals(this.getTimeout())) {
            return false;
        }
        if (other.getMemorySize() == null ^ this.getMemorySize() == null) {
            return false;
        }
        if (other.getMemorySize() != null && !other.getMemorySize().equals(this.getMemorySize())) {
            return false;
        }
        if (other.getLastModified() == null ^ this.getLastModified() == null) {
            return false;
        }
        if (other.getLastModified() != null && !other.getLastModified().equals(this.getLastModified())) {
            return false;
        }
        if (other.getCodeSha256() == null ^ this.getCodeSha256() == null) {
            return false;
        }
        if (other.getCodeSha256() != null && !other.getCodeSha256().equals(this.getCodeSha256())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getDeadLetterConfig() == null ^ this.getDeadLetterConfig() == null) {
            return false;
        }
        if (other.getDeadLetterConfig() != null && !other.getDeadLetterConfig().equals(this.getDeadLetterConfig())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getKMSKeyArn() == null ^ this.getKMSKeyArn() == null) {
            return false;
        }
        if (other.getKMSKeyArn() != null && !other.getKMSKeyArn().equals(this.getKMSKeyArn())) {
            return false;
        }
        if (other.getTracingConfig() == null ^ this.getTracingConfig() == null) {
            return false;
        }
        if (other.getTracingConfig() != null && !other.getTracingConfig().equals(this.getTracingConfig())) {
            return false;
        }
        if (other.getMasterArn() == null ^ this.getMasterArn() == null) {
            return false;
        }
        if (other.getMasterArn() != null && !other.getMasterArn().equals(this.getMasterArn())) {
            return false;
        }
        if (other.getRevisionId() == null ^ this.getRevisionId() == null) {
            return false;
        }
        if (other.getRevisionId() != null && !other.getRevisionId().equals(this.getRevisionId())) {
            return false;
        }
        if (other.getLayers() == null ^ this.getLayers() == null) {
            return false;
        }
        if (other.getLayers() != null && !other.getLayers().equals(this.getLayers())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStateReason() == null ^ this.getStateReason() == null) {
            return false;
        }
        if (other.getStateReason() != null && !other.getStateReason().equals(this.getStateReason())) {
            return false;
        }
        if (other.getStateReasonCode() == null ^ this.getStateReasonCode() == null) {
            return false;
        }
        if (other.getStateReasonCode() != null && !other.getStateReasonCode().equals(this.getStateReasonCode())) {
            return false;
        }
        if (other.getLastUpdateStatus() == null ^ this.getLastUpdateStatus() == null) {
            return false;
        }
        if (other.getLastUpdateStatus() != null && !other.getLastUpdateStatus().equals(this.getLastUpdateStatus())) {
            return false;
        }
        if (other.getLastUpdateStatusReason() == null ^ this.getLastUpdateStatusReason() == null) {
            return false;
        }
        if (other.getLastUpdateStatusReason() != null && !other.getLastUpdateStatusReason().equals(this.getLastUpdateStatusReason())) {
            return false;
        }
        if (other.getLastUpdateStatusReasonCode() == null ^ this.getLastUpdateStatusReasonCode() == null) {
            return false;
        }
        if (other.getLastUpdateStatusReasonCode() != null && !other.getLastUpdateStatusReasonCode().equals(this.getLastUpdateStatusReasonCode())) {
            return false;
        }
        if (other.getFileSystemConfigs() == null ^ this.getFileSystemConfigs() == null) {
            return false;
        }
        if (other.getFileSystemConfigs() != null && !other.getFileSystemConfigs().equals(this.getFileSystemConfigs())) {
            return false;
        }
        if (other.getPackageType() == null ^ this.getPackageType() == null) {
            return false;
        }
        if (other.getPackageType() != null && !other.getPackageType().equals(this.getPackageType())) {
            return false;
        }
        if (other.getImageConfigResponse() == null ^ this.getImageConfigResponse() == null) {
            return false;
        }
        if (other.getImageConfigResponse() != null && !other.getImageConfigResponse().equals(this.getImageConfigResponse())) {
            return false;
        }
        if (other.getSigningProfileVersionArn() == null ^ this.getSigningProfileVersionArn() == null) {
            return false;
        }
        if (other.getSigningProfileVersionArn() != null && !other.getSigningProfileVersionArn().equals(this.getSigningProfileVersionArn())) {
            return false;
        }
        if (other.getSigningJobArn() == null ^ this.getSigningJobArn() == null) {
            return false;
        }
        if (other.getSigningJobArn() != null && !other.getSigningJobArn().equals(this.getSigningJobArn())) {
            return false;
        }
        if (other.getArchitectures() == null ^ this.getArchitectures() == null) {
            return false;
        }
        if (other.getArchitectures() != null && !other.getArchitectures().equals(this.getArchitectures())) {
            return false;
        }
        if (other.getEphemeralStorage() == null ^ this.getEphemeralStorage() == null) {
            return false;
        }
        if (other.getEphemeralStorage() != null && !other.getEphemeralStorage().equals(this.getEphemeralStorage())) {
            return false;
        }
        if (other.getSnapStart() == null ^ this.getSnapStart() == null) {
            return false;
        }
        if (other.getSnapStart() != null && !other.getSnapStart().equals(this.getSnapStart())) {
            return false;
        }
        if (other.getRuntimeVersionConfig() == null ^ this.getRuntimeVersionConfig() == null) {
            return false;
        }
        if (other.getRuntimeVersionConfig() != null && !other.getRuntimeVersionConfig().equals(this.getRuntimeVersionConfig())) {
            return false;
        }
        if (other.getLoggingConfig() == null ^ this.getLoggingConfig() == null) {
            return false;
        }
        return other.getLoggingConfig() == null || other.getLoggingConfig().equals(this.getLoggingConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctionName() == null ? 0 : this.getFunctionName().hashCode());
        hashCode = 31 * hashCode + (this.getFunctionArn() == null ? 0 : this.getFunctionArn().hashCode());
        hashCode = 31 * hashCode + (this.getRuntime() == null ? 0 : this.getRuntime().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getHandler() == null ? 0 : this.getHandler().hashCode());
        hashCode = 31 * hashCode + (this.getCodeSize() == null ? 0 : this.getCodeSize().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTimeout() == null ? 0 : this.getTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getMemorySize() == null ? 0 : this.getMemorySize().hashCode());
        hashCode = 31 * hashCode + (this.getLastModified() == null ? 0 : this.getLastModified().hashCode());
        hashCode = 31 * hashCode + (this.getCodeSha256() == null ? 0 : this.getCodeSha256().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDeadLetterConfig() == null ? 0 : this.getDeadLetterConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getKMSKeyArn() == null ? 0 : this.getKMSKeyArn().hashCode());
        hashCode = 31 * hashCode + (this.getTracingConfig() == null ? 0 : this.getTracingConfig().hashCode());
        hashCode = 31 * hashCode + (this.getMasterArn() == null ? 0 : this.getMasterArn().hashCode());
        hashCode = 31 * hashCode + (this.getRevisionId() == null ? 0 : this.getRevisionId().hashCode());
        hashCode = 31 * hashCode + (this.getLayers() == null ? 0 : this.getLayers().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStateReason() == null ? 0 : this.getStateReason().hashCode());
        hashCode = 31 * hashCode + (this.getStateReasonCode() == null ? 0 : this.getStateReasonCode().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateStatus() == null ? 0 : this.getLastUpdateStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateStatusReason() == null ? 0 : this.getLastUpdateStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateStatusReasonCode() == null ? 0 : this.getLastUpdateStatusReasonCode().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemConfigs() == null ? 0 : this.getFileSystemConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getPackageType() == null ? 0 : this.getPackageType().hashCode());
        hashCode = 31 * hashCode + (this.getImageConfigResponse() == null ? 0 : this.getImageConfigResponse().hashCode());
        hashCode = 31 * hashCode + (this.getSigningProfileVersionArn() == null ? 0 : this.getSigningProfileVersionArn().hashCode());
        hashCode = 31 * hashCode + (this.getSigningJobArn() == null ? 0 : this.getSigningJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getArchitectures() == null ? 0 : this.getArchitectures().hashCode());
        hashCode = 31 * hashCode + (this.getEphemeralStorage() == null ? 0 : this.getEphemeralStorage().hashCode());
        hashCode = 31 * hashCode + (this.getSnapStart() == null ? 0 : this.getSnapStart().hashCode());
        hashCode = 31 * hashCode + (this.getRuntimeVersionConfig() == null ? 0 : this.getRuntimeVersionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getLoggingConfig() == null ? 0 : this.getLoggingConfig().hashCode());
        return hashCode;
    }

    public FunctionConfiguration clone() {
        try {
            return (FunctionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

