/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.TaggedDatabase;
import java.util.List;

@SdkInternalApi
public class TaggedDatabaseMarshaller {
    private static final MarshallingInfo<StructuredPojo> DATABASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Database").build();
    private static final MarshallingInfo<List> LFTAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LFTags").build();
    private static final TaggedDatabaseMarshaller instance = new TaggedDatabaseMarshaller();

    public static TaggedDatabaseMarshaller getInstance() {
        return instance;
    }

    public void marshall(TaggedDatabase taggedDatabase, ProtocolMarshaller protocolMarshaller) {
        if (taggedDatabase == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)taggedDatabase.getDatabase(), DATABASE_BINDING);
            protocolMarshaller.marshall(taggedDatabase.getLFTags(), LFTAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

