/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lakeformation.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ListTableStorageOptimizers"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListTableStorageOptimizersRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The Catalog ID of the table.
     * </p>
     */
    private String catalogId;
    /**
     * <p>
     * Name of the database where the table is present.
     * </p>
     */
    private String databaseName;
    /**
     * <p>
     * Name of the table.
     * </p>
     */
    private String tableName;
    /**
     * <p>
     * The specific type of storage optimizers to list. The supported value is <code>compaction</code>.
     * </p>
     */
    private String storageOptimizerType;
    /**
     * <p>
     * The number of storage optimizers to return on each call.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The Catalog ID of the table.
     * </p>
     * 
     * @param catalogId
     *        The Catalog ID of the table.
     */

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    /**
     * <p>
     * The Catalog ID of the table.
     * </p>
     * 
     * @return The Catalog ID of the table.
     */

    public String getCatalogId() {
        return this.catalogId;
    }

    /**
     * <p>
     * The Catalog ID of the table.
     * </p>
     * 
     * @param catalogId
     *        The Catalog ID of the table.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTableStorageOptimizersRequest withCatalogId(String catalogId) {
        setCatalogId(catalogId);
        return this;
    }

    /**
     * <p>
     * Name of the database where the table is present.
     * </p>
     * 
     * @param databaseName
     *        Name of the database where the table is present.
     */

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    /**
     * <p>
     * Name of the database where the table is present.
     * </p>
     * 
     * @return Name of the database where the table is present.
     */

    public String getDatabaseName() {
        return this.databaseName;
    }

    /**
     * <p>
     * Name of the database where the table is present.
     * </p>
     * 
     * @param databaseName
     *        Name of the database where the table is present.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTableStorageOptimizersRequest withDatabaseName(String databaseName) {
        setDatabaseName(databaseName);
        return this;
    }

    /**
     * <p>
     * Name of the table.
     * </p>
     * 
     * @param tableName
     *        Name of the table.
     */

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /**
     * <p>
     * Name of the table.
     * </p>
     * 
     * @return Name of the table.
     */

    public String getTableName() {
        return this.tableName;
    }

    /**
     * <p>
     * Name of the table.
     * </p>
     * 
     * @param tableName
     *        Name of the table.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTableStorageOptimizersRequest withTableName(String tableName) {
        setTableName(tableName);
        return this;
    }

    /**
     * <p>
     * The specific type of storage optimizers to list. The supported value is <code>compaction</code>.
     * </p>
     * 
     * @param storageOptimizerType
     *        The specific type of storage optimizers to list. The supported value is <code>compaction</code>.
     * @see OptimizerType
     */

    public void setStorageOptimizerType(String storageOptimizerType) {
        this.storageOptimizerType = storageOptimizerType;
    }

    /**
     * <p>
     * The specific type of storage optimizers to list. The supported value is <code>compaction</code>.
     * </p>
     * 
     * @return The specific type of storage optimizers to list. The supported value is <code>compaction</code>.
     * @see OptimizerType
     */

    public String getStorageOptimizerType() {
        return this.storageOptimizerType;
    }

    /**
     * <p>
     * The specific type of storage optimizers to list. The supported value is <code>compaction</code>.
     * </p>
     * 
     * @param storageOptimizerType
     *        The specific type of storage optimizers to list. The supported value is <code>compaction</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see OptimizerType
     */

    public ListTableStorageOptimizersRequest withStorageOptimizerType(String storageOptimizerType) {
        setStorageOptimizerType(storageOptimizerType);
        return this;
    }

    /**
     * <p>
     * The specific type of storage optimizers to list. The supported value is <code>compaction</code>.
     * </p>
     * 
     * @param storageOptimizerType
     *        The specific type of storage optimizers to list. The supported value is <code>compaction</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see OptimizerType
     */

    public ListTableStorageOptimizersRequest withStorageOptimizerType(OptimizerType storageOptimizerType) {
        this.storageOptimizerType = storageOptimizerType.toString();
        return this;
    }

    /**
     * <p>
     * The number of storage optimizers to return on each call.
     * </p>
     * 
     * @param maxResults
     *        The number of storage optimizers to return on each call.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The number of storage optimizers to return on each call.
     * </p>
     * 
     * @return The number of storage optimizers to return on each call.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The number of storage optimizers to return on each call.
     * </p>
     * 
     * @param maxResults
     *        The number of storage optimizers to return on each call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTableStorageOptimizersRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     * 
     * @param nextToken
     *        A continuation token, if this is a continuation call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, if this is a continuation call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     * 
     * @param nextToken
     *        A continuation token, if this is a continuation call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTableStorageOptimizersRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCatalogId() != null)
            sb.append("CatalogId: ").append(getCatalogId()).append(",");
        if (getDatabaseName() != null)
            sb.append("DatabaseName: ").append(getDatabaseName()).append(",");
        if (getTableName() != null)
            sb.append("TableName: ").append(getTableName()).append(",");
        if (getStorageOptimizerType() != null)
            sb.append("StorageOptimizerType: ").append(getStorageOptimizerType()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListTableStorageOptimizersRequest == false)
            return false;
        ListTableStorageOptimizersRequest other = (ListTableStorageOptimizersRequest) obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null)
            return false;
        if (other.getCatalogId() != null && other.getCatalogId().equals(this.getCatalogId()) == false)
            return false;
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null)
            return false;
        if (other.getDatabaseName() != null && other.getDatabaseName().equals(this.getDatabaseName()) == false)
            return false;
        if (other.getTableName() == null ^ this.getTableName() == null)
            return false;
        if (other.getTableName() != null && other.getTableName().equals(this.getTableName()) == false)
            return false;
        if (other.getStorageOptimizerType() == null ^ this.getStorageOptimizerType() == null)
            return false;
        if (other.getStorageOptimizerType() != null && other.getStorageOptimizerType().equals(this.getStorageOptimizerType()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCatalogId() == null) ? 0 : getCatalogId().hashCode());
        hashCode = prime * hashCode + ((getDatabaseName() == null) ? 0 : getDatabaseName().hashCode());
        hashCode = prime * hashCode + ((getTableName() == null) ? 0 : getTableName().hashCode());
        hashCode = prime * hashCode + ((getStorageOptimizerType() == null) ? 0 : getStorageOptimizerType().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListTableStorageOptimizersRequest clone() {
        return (ListTableStorageOptimizersRequest) super.clone();
    }

}
