/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.internal.netty.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PutMediaHandlerInitializer
extends ChannelInitializer<Channel> {
    private static final Log log = LogFactory.getLog(PutMediaHandlerInitializer.class);
    private final SslContext sslContext;
    private final List<ChannelHandler> handlers;

    public PutMediaHandlerInitializer(SslContext sslContext, List<ChannelHandler> handlers) {
        this.sslContext = sslContext;
        this.handlers = new ArrayList<ChannelHandler>(handlers);
    }

    public void initChannel(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        if (log.isDebugEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler()});
        }
        if (this.sslContext != null) {
            pipeline.addLast("ssl", (ChannelHandler)this.sslContext.newHandler(channel.alloc()));
        }
        pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
        for (ChannelHandler handler : this.handlers) {
            pipeline.addLast(new ChannelHandler[]{handler});
        }
        pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
    }
}

