/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisanalyticsv2.model.MavenReference;

@SdkInternalApi
public class MavenReferenceMarshaller {
    private static final MarshallingInfo<String> GROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupId").build();
    private static final MarshallingInfo<String> ARTIFACTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArtifactId").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final MavenReferenceMarshaller instance = new MavenReferenceMarshaller();

    public static MavenReferenceMarshaller getInstance() {
        return instance;
    }

    public void marshall(MavenReference mavenReference, ProtocolMarshaller protocolMarshaller) {
        if (mavenReference == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mavenReference.getGroupId(), GROUPID_BINDING);
            protocolMarshaller.marshall((Object)mavenReference.getArtifactId(), ARTIFACTID_BINDING);
            protocolMarshaller.marshall((Object)mavenReference.getVersion(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

