/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kinesisfirehose.model.Record;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutRecordBatchRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String deliveryStreamName;
    private List<Record> records;

    public void setDeliveryStreamName(String deliveryStreamName) {
        this.deliveryStreamName = deliveryStreamName;
    }

    public String getDeliveryStreamName() {
        return this.deliveryStreamName;
    }

    public PutRecordBatchRequest withDeliveryStreamName(String deliveryStreamName) {
        this.setDeliveryStreamName(deliveryStreamName);
        return this;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void setRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        this.records = new ArrayList<Record>(records);
    }

    public PutRecordBatchRequest withRecords(Record ... records) {
        if (this.records == null) {
            this.setRecords(new ArrayList<Record>(records.length));
        }
        for (Record ele : records) {
            this.records.add(ele);
        }
        return this;
    }

    public PutRecordBatchRequest withRecords(Collection<Record> records) {
        this.setRecords(records);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.getDeliveryStreamName()).append(",");
        }
        if (this.getRecords() != null) {
            sb.append("Records: ").append(this.getRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchRequest)) {
            return false;
        }
        PutRecordBatchRequest other = (PutRecordBatchRequest)obj;
        if (other.getDeliveryStreamName() == null ^ this.getDeliveryStreamName() == null) {
            return false;
        }
        if (other.getDeliveryStreamName() != null && !other.getDeliveryStreamName().equals(this.getDeliveryStreamName())) {
            return false;
        }
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        return other.getRecords() == null || other.getRecords().equals(this.getRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeliveryStreamName() == null ? 0 : this.getDeliveryStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        return hashCode;
    }

    public PutRecordBatchRequest clone() {
        return (PutRecordBatchRequest)super.clone();
    }
}

