/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisfirehose.model.RedshiftDestinationConfiguration;
import com.amazonaws.services.kinesisfirehose.model.transform.CloudWatchLoggingOptionsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.CopyCommandJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.ProcessingConfigurationJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.RedshiftRetryOptionsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.S3DestinationConfigurationJsonMarshaller;

public class RedshiftDestinationConfigurationJsonMarshaller {
    private static RedshiftDestinationConfigurationJsonMarshaller instance;

    public void marshall(RedshiftDestinationConfiguration redshiftDestinationConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (redshiftDestinationConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (redshiftDestinationConfiguration.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(redshiftDestinationConfiguration.getRoleARN());
            }
            if (redshiftDestinationConfiguration.getClusterJDBCURL() != null) {
                jsonGenerator.writeFieldName("ClusterJDBCURL").writeValue(redshiftDestinationConfiguration.getClusterJDBCURL());
            }
            if (redshiftDestinationConfiguration.getCopyCommand() != null) {
                jsonGenerator.writeFieldName("CopyCommand");
                CopyCommandJsonMarshaller.getInstance().marshall(redshiftDestinationConfiguration.getCopyCommand(), jsonGenerator);
            }
            if (redshiftDestinationConfiguration.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(redshiftDestinationConfiguration.getUsername());
            }
            if (redshiftDestinationConfiguration.getPassword() != null) {
                jsonGenerator.writeFieldName("Password").writeValue(redshiftDestinationConfiguration.getPassword());
            }
            if (redshiftDestinationConfiguration.getRetryOptions() != null) {
                jsonGenerator.writeFieldName("RetryOptions");
                RedshiftRetryOptionsJsonMarshaller.getInstance().marshall(redshiftDestinationConfiguration.getRetryOptions(), jsonGenerator);
            }
            if (redshiftDestinationConfiguration.getS3Configuration() != null) {
                jsonGenerator.writeFieldName("S3Configuration");
                S3DestinationConfigurationJsonMarshaller.getInstance().marshall(redshiftDestinationConfiguration.getS3Configuration(), jsonGenerator);
            }
            if (redshiftDestinationConfiguration.getProcessingConfiguration() != null) {
                jsonGenerator.writeFieldName("ProcessingConfiguration");
                ProcessingConfigurationJsonMarshaller.getInstance().marshall(redshiftDestinationConfiguration.getProcessingConfiguration(), jsonGenerator);
            }
            if (redshiftDestinationConfiguration.getS3BackupMode() != null) {
                jsonGenerator.writeFieldName("S3BackupMode").writeValue(redshiftDestinationConfiguration.getS3BackupMode());
            }
            if (redshiftDestinationConfiguration.getS3BackupConfiguration() != null) {
                jsonGenerator.writeFieldName("S3BackupConfiguration");
                S3DestinationConfigurationJsonMarshaller.getInstance().marshall(redshiftDestinationConfiguration.getS3BackupConfiguration(), jsonGenerator);
            }
            if (redshiftDestinationConfiguration.getCloudWatchLoggingOptions() != null) {
                jsonGenerator.writeFieldName("CloudWatchLoggingOptions");
                CloudWatchLoggingOptionsJsonMarshaller.getInstance().marshall(redshiftDestinationConfiguration.getCloudWatchLoggingOptions(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RedshiftDestinationConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RedshiftDestinationConfigurationJsonMarshaller();
        }
        return instance;
    }
}

