/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisanalytics.AmazonKinesisAnalyticsAsync;
import com.amazonaws.services.kinesisanalytics.AmazonKinesisAnalyticsClient;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationInputRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationInputResult;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationOutputRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationOutputResult;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationReferenceDataSourceResult;
import com.amazonaws.services.kinesisanalytics.model.CreateApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.CreateApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationOutputRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationOutputResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResult;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.DescribeApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.DescribeApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.DiscoverInputSchemaRequest;
import com.amazonaws.services.kinesisanalytics.model.DiscoverInputSchemaResult;
import com.amazonaws.services.kinesisanalytics.model.ListApplicationsRequest;
import com.amazonaws.services.kinesisanalytics.model.ListApplicationsResult;
import com.amazonaws.services.kinesisanalytics.model.StartApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.StartApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.StopApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.StopApplicationResult;
import com.amazonaws.services.kinesisanalytics.model.UpdateApplicationRequest;
import com.amazonaws.services.kinesisanalytics.model.UpdateApplicationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisAnalyticsAsyncClient
extends AmazonKinesisAnalyticsClient
implements AmazonKinesisAnalyticsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonKinesisAnalyticsAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonKinesisAnalyticsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonKinesisAnalyticsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonKinesisAnalyticsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonKinesisAnalyticsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonKinesisAnalyticsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonKinesisAnalyticsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonKinesisAnalyticsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonKinesisAnalyticsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonKinesisAnalyticsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddApplicationInputResult> addApplicationInputAsync(AddApplicationInputRequest request) {
        return this.addApplicationInputAsync(request, null);
    }

    @Override
    public Future<AddApplicationInputResult> addApplicationInputAsync(final AddApplicationInputRequest request, final AsyncHandler<AddApplicationInputRequest, AddApplicationInputResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddApplicationInputResult>(){

            @Override
            public AddApplicationInputResult call() throws Exception {
                AddApplicationInputResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.addApplicationInput(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddApplicationOutputResult> addApplicationOutputAsync(AddApplicationOutputRequest request) {
        return this.addApplicationOutputAsync(request, null);
    }

    @Override
    public Future<AddApplicationOutputResult> addApplicationOutputAsync(final AddApplicationOutputRequest request, final AsyncHandler<AddApplicationOutputRequest, AddApplicationOutputResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddApplicationOutputResult>(){

            @Override
            public AddApplicationOutputResult call() throws Exception {
                AddApplicationOutputResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.addApplicationOutput(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddApplicationReferenceDataSourceResult> addApplicationReferenceDataSourceAsync(AddApplicationReferenceDataSourceRequest request) {
        return this.addApplicationReferenceDataSourceAsync(request, null);
    }

    @Override
    public Future<AddApplicationReferenceDataSourceResult> addApplicationReferenceDataSourceAsync(final AddApplicationReferenceDataSourceRequest request, final AsyncHandler<AddApplicationReferenceDataSourceRequest, AddApplicationReferenceDataSourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddApplicationReferenceDataSourceResult>(){

            @Override
            public AddApplicationReferenceDataSourceResult call() throws Exception {
                AddApplicationReferenceDataSourceResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.addApplicationReferenceDataSource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationAsync(request, null);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(final CreateApplicationRequest request, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.createApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request) {
        return this.deleteApplicationAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(final DeleteApplicationRequest request, final AsyncHandler<DeleteApplicationRequest, DeleteApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteApplicationResult>(){

            @Override
            public DeleteApplicationResult call() throws Exception {
                DeleteApplicationResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.deleteApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationOutputResult> deleteApplicationOutputAsync(DeleteApplicationOutputRequest request) {
        return this.deleteApplicationOutputAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationOutputResult> deleteApplicationOutputAsync(final DeleteApplicationOutputRequest request, final AsyncHandler<DeleteApplicationOutputRequest, DeleteApplicationOutputResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteApplicationOutputResult>(){

            @Override
            public DeleteApplicationOutputResult call() throws Exception {
                DeleteApplicationOutputResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.deleteApplicationOutput(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationReferenceDataSourceResult> deleteApplicationReferenceDataSourceAsync(DeleteApplicationReferenceDataSourceRequest request) {
        return this.deleteApplicationReferenceDataSourceAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationReferenceDataSourceResult> deleteApplicationReferenceDataSourceAsync(final DeleteApplicationReferenceDataSourceRequest request, final AsyncHandler<DeleteApplicationReferenceDataSourceRequest, DeleteApplicationReferenceDataSourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteApplicationReferenceDataSourceResult>(){

            @Override
            public DeleteApplicationReferenceDataSourceResult call() throws Exception {
                DeleteApplicationReferenceDataSourceResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.deleteApplicationReferenceDataSource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeApplicationResult> describeApplicationAsync(DescribeApplicationRequest request) {
        return this.describeApplicationAsync(request, null);
    }

    @Override
    public Future<DescribeApplicationResult> describeApplicationAsync(final DescribeApplicationRequest request, final AsyncHandler<DescribeApplicationRequest, DescribeApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeApplicationResult>(){

            @Override
            public DescribeApplicationResult call() throws Exception {
                DescribeApplicationResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.describeApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DiscoverInputSchemaResult> discoverInputSchemaAsync(DiscoverInputSchemaRequest request) {
        return this.discoverInputSchemaAsync(request, null);
    }

    @Override
    public Future<DiscoverInputSchemaResult> discoverInputSchemaAsync(final DiscoverInputSchemaRequest request, final AsyncHandler<DiscoverInputSchemaRequest, DiscoverInputSchemaResult> asyncHandler) {
        return this.executorService.submit(new Callable<DiscoverInputSchemaResult>(){

            @Override
            public DiscoverInputSchemaResult call() throws Exception {
                DiscoverInputSchemaResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.discoverInputSchema(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {
        return this.listApplicationsAsync(request, null);
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(final ListApplicationsRequest request, final AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListApplicationsResult>(){

            @Override
            public ListApplicationsResult call() throws Exception {
                ListApplicationsResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.listApplications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartApplicationResult> startApplicationAsync(StartApplicationRequest request) {
        return this.startApplicationAsync(request, null);
    }

    @Override
    public Future<StartApplicationResult> startApplicationAsync(final StartApplicationRequest request, final AsyncHandler<StartApplicationRequest, StartApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartApplicationResult>(){

            @Override
            public StartApplicationResult call() throws Exception {
                StartApplicationResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.startApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopApplicationResult> stopApplicationAsync(StopApplicationRequest request) {
        return this.stopApplicationAsync(request, null);
    }

    @Override
    public Future<StopApplicationResult> stopApplicationAsync(final StopApplicationRequest request, final AsyncHandler<StopApplicationRequest, StopApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<StopApplicationResult>(){

            @Override
            public StopApplicationResult call() throws Exception {
                StopApplicationResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.stopApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationAsync(request, null);
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(final UpdateApplicationRequest request, final AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateApplicationResult>(){

            @Override
            public UpdateApplicationResult call() throws Exception {
                UpdateApplicationResult result;
                try {
                    result = AmazonKinesisAnalyticsAsyncClient.this.updateApplication(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

