/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.amazonaws.services.kinesis.model.transform.PutRecordsRequestEntryJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutRecordsRequestMarshaller
implements Marshaller<Request<PutRecordsRequest>, PutRecordsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutRecordsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutRecordsRequest> marshall(PutRecordsRequest putRecordsRequest) {
        if (putRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putRecordsRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.PutRecords");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList recordsList = (SdkInternalList)putRecordsRequest.getRecords();
            if (!recordsList.isEmpty() || !recordsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Records");
                jsonGenerator.writeStartArray();
                for (PutRecordsRequestEntry recordsListValue : recordsList) {
                    if (recordsListValue == null) continue;
                    PutRecordsRequestEntryJsonMarshaller.getInstance().marshall(recordsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (putRecordsRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(putRecordsRequest.getStreamName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

