/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.EnhancedMetrics;

public class EnhancedMetricsJsonMarshaller {
    private static EnhancedMetricsJsonMarshaller instance;

    public void marshall(EnhancedMetrics enhancedMetrics, StructuredJsonGenerator jsonGenerator) {
        if (enhancedMetrics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList shardLevelMetricsList = (SdkInternalList)enhancedMetrics.getShardLevelMetrics();
            if (!shardLevelMetricsList.isEmpty() || !shardLevelMetricsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ShardLevelMetrics");
                jsonGenerator.writeStartArray();
                for (String shardLevelMetricsListValue : shardLevelMetricsList) {
                    if (shardLevelMetricsListValue == null) continue;
                    jsonGenerator.writeValue(shardLevelMetricsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EnhancedMetricsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EnhancedMetricsJsonMarshaller();
        }
        return instance;
    }
}

