/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.Output;
import com.amazonaws.services.kinesisanalytics.model.transform.DestinationSchemaJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisFirehoseOutputJsonMarshaller;
import com.amazonaws.services.kinesisanalytics.model.transform.KinesisStreamsOutputJsonMarshaller;

public class OutputJsonMarshaller {
    private static OutputJsonMarshaller instance;

    public void marshall(Output output, StructuredJsonGenerator jsonGenerator) {
        if (output == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (output.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(output.getName());
            }
            if (output.getKinesisStreamsOutput() != null) {
                jsonGenerator.writeFieldName("KinesisStreamsOutput");
                KinesisStreamsOutputJsonMarshaller.getInstance().marshall(output.getKinesisStreamsOutput(), jsonGenerator);
            }
            if (output.getKinesisFirehoseOutput() != null) {
                jsonGenerator.writeFieldName("KinesisFirehoseOutput");
                KinesisFirehoseOutputJsonMarshaller.getInstance().marshall(output.getKinesisFirehoseOutput(), jsonGenerator);
            }
            if (output.getDestinationSchema() != null) {
                jsonGenerator.writeFieldName("DestinationSchema");
                DestinationSchemaJsonMarshaller.getInstance().marshall(output.getDestinationSchema(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static OutputJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new OutputJsonMarshaller();
        }
        return instance;
    }
}

