/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.AddApplicationOutputRequest;
import com.amazonaws.services.kinesisanalytics.model.transform.OutputJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AddApplicationOutputRequestMarshaller
implements Marshaller<Request<AddApplicationOutputRequest>, AddApplicationOutputRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AddApplicationOutputRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AddApplicationOutputRequest> marshall(AddApplicationOutputRequest addApplicationOutputRequest) {
        if (addApplicationOutputRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addApplicationOutputRequest, "AmazonKinesisAnalytics");
        request.addHeader("X-Amz-Target", "KinesisAnalytics_20150814.AddApplicationOutput");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (addApplicationOutputRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("ApplicationName").writeValue(addApplicationOutputRequest.getApplicationName());
            }
            if (addApplicationOutputRequest.getCurrentApplicationVersionId() != null) {
                jsonGenerator.writeFieldName("CurrentApplicationVersionId").writeValue(addApplicationOutputRequest.getCurrentApplicationVersionId().longValue());
            }
            if (addApplicationOutputRequest.getOutput() != null) {
                jsonGenerator.writeFieldName("Output");
                OutputJsonMarshaller.getInstance().marshall(addApplicationOutputRequest.getOutput(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

